;; -*- scheme -*-

;;=====================================================================
;;
;;                    Test and Debugging Stuff
;;
;;=====================================================================


;;=====================================================================
;; reload the world
;;=====================================================================
(define x
  (lambda ()
    (gf-load "guile-fu.scm")
    (gf-init)))



;;=====================================================================
;;  Chalice protocol test driver
;;=====================================================================

(define q
  (lambda (n)
    (chalice-start (script n) (node n) "parms")))

(define w
  (lambda ()
    (chalice-retrieve)))

(define e
  (lambda ()
    (chalice-stop)))

(define r
  (lambda (n)
    (chalice-execute (script n) (node n) "parms")))

(define t
  (lambda (n)
    (chalice-verify (script n) (node n) "parms")))


;;=====================================================================
;;  guile-fu testing
;;=====================================================================

;; guile-fu calling conventions
(define a
  (lambda ()
    (let ((img (file-jpeg-load 'image 0 "foo.jpg" "foo.jpg")))
      (gimp-display-new 'display img))))

;; script-fu calling conventions
(define s
  (lambda ()
    (let ((img (file-jpeg-load 0 "foo.jpg" "foo.jpg")))
      (gimp-display-new (car img)))))


;;=====================================================================
;;  Node/script factory
;;=====================================================================

(define (qq n)
  (cadr (assq (if (< n 4) n 1)
              '((1 ((node (image 128 128 GRAY)
                          (layer))
                    "The script for node 1"))
                (2 ((node (image 256 256 RGB)
                          (layer)
                          (mask)
                          (layer))
                    "The script for node 2"))
                (3 ((node (image 175 300 RGB)
                          (layer)
                          (mask)
                          (layer)
                          (layer)
                          (mask)
                          (layer)
                          (mask)
                          (layer)
                          (layer))
                    "The script for node 3"))
                ))))
(define (node n) (car (qq n)))
(define (script n) (cadr (qq n)))


;;=====================================================================
;;  Test cases
;;=====================================================================

(define (test-node-valid?)
  (define pass
    '((node (image 1 2 RGB)
            (layer))    
      (node (image 1 2 GRAY)
            (layer)
            (layer))
      (node (image 1 2 RGB)
            (layer)
            (mask))
      (node (image 1 2 RGB)
            (layer)
            (mask)
            (layer))
      (node (image 1 2 RGB)
            (layer)
            (layer)
            (mask))))
  (define fail
    '((nodd (image 1 2 RGB)
            (layer))
      (node (omage 1 2 RGB)
            (layer))
      (node (image 1 0 RGB)
            (layer))
      (node (image 1 2 3)
            (layer))
      (node (image 1 2 RGB))
      (node (image 1 2 RGB)
            (mask))
      (node (image 1 2 RGB)
            (layer)
            (mask)
            (mask))))

  (define (test n)
    ((make-node n) 'valid?))

  (print (map test pass))
  (print (map test fail)))



