/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MEMORY_SHM_H__
#define __MEMORY_SHM_H__

#include <glib.h>

typedef struct _GimpShmPtr GimpShmPtr;
typedef struct _GimpShmMgr GimpShmMgr;


/* a unique identifier for a section of an OS shm segment */
typedef guint GimpShmId;
#define InvalidGimpShmId 0

/* a pointer into a piece of OS shared memory.  'id' encodes both the
   segment and the offset. 'data' will be NULL if usecount == 0 and
   may change value when usecount touches 0 */
struct _GimpShmPtr
{
  /* the GimpShm we are associated with */
  GimpShmId id;

  /* the number of local refs */
  guint usecount;

  /* a local copy of the data pointer in the GimpShm */
  void * data;
};

#define   gsp_is_alloced(gsp)    ((gsp)->id != InvalidGimpShmId)
#define   gsp_usecount(gsp)      ((gsp)->usecount)
#define   gsp_data(gsp)          ((gsp)->data)

/* create and destroy a pointer */
void      gimp_shmptr_init      (GimpShmPtr  *ptr);
void      gimp_shmptr_uninit    (GimpShmPtr  *ptr);

/* attach/detach to a part of a shm segment.  id is assigned by
   the shmmgr.  you cannot detach a ptr with outstanding uses */
gboolean  gimp_shmptr_attach    (GimpShmPtr  *ptr,
                                 GimpShmId    id);
gboolean  gimp_shmptr_detach    (GimpShmPtr  *ptr);

/* assert/negate your intention to use ptr.  ptr must be attached */
gboolean  gimp_shmptr_use       (GimpShmPtr  *ptr);
gboolean  gimp_shmptr_unuse     (GimpShmPtr  *ptr);


/* routines for ShmMgr */


#endif /* __MEMORY_SHM_H__ */
