/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cow.h"


void
DEBUG_mem (GimpMem * mem)
{
  g_return_if_fail (mem != NULL);

  if (mem->ptrcount)
    g_return_if_fail (mem->size != 0);
  if (mem->usecount)
    g_return_if_fail (mem->ptrcount != 0);
  if (mem->sharable == FALSE)
    {
      g_return_if_fail (mem->ptrcount == 1);
      g_return_if_fail (mem->usecount > 0);
    }

  if (mem->usecount != 0)
    {
      /* active */
      g_return_if_fail (mem->data != NULL);
      g_return_if_fail (mem->size != 0);
      g_return_if_fail (mem->ptrcount != 0);
      /* g_return_if_fail (mem->cache.list == &active); */
    }
  else if (mem->data != NULL)
    {
      /* inactive */
      g_return_if_fail (mem->size != 0);
      g_return_if_fail (mem->ptrcount != 0);
      /* g_return_if_fail (mem->cache.list == &inactive); */
    }
  else if (mem->ptrcount != 0)
    {
      /* swapped */
      g_return_if_fail (mem->size != 0);
      /* g_return_if_fail (mem->cache.list == &swapped); */
    }
  else if (mem->size == 0)
    {
      /* unalloced */
      g_return_if_fail (mem->cache.list == NULL);
    }  
}

void
DEBUG_memptr (GimpMemPtr * ptr)
{
  g_return_if_fail (ptr != NULL);

  if (ptr->mem == NULL)
    {
      g_return_if_fail (ptr->usecount == 0);
      g_return_if_fail (ptr->joined == FALSE);
      g_return_if_fail (ptr->size == 0);
      g_return_if_fail (ptr->data == NULL);
    }
  else
    {
      DEBUG_mem (ptr->mem);
      
      g_return_if_fail (ptr->size != 0);

      if (ptr->mem->ptrcount > 1)
        {
          g_return_if_fail (ptr->joined != FALSE);
        }
      
      if (ptr->usecount == 0)
        {
          g_return_if_fail (ptr->data == NULL);
        }
      else
        {
          g_return_if_fail (ptr->data != NULL);
        }
    }
}

