/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __SWAP_H__
#define __SWAP_H__

#include <sys/types.h>
#include <glib.h>

typedef struct _SwapFile SwapFile;
typedef gint             SwapTag;

struct _SwapFile
{
  /* the file to store data in */
  gchar *filename;

  /* current file size */
  gulong size;

  /* file descriptor if the file is open */
  gint fd;

  /* current position if file is open */
  off_t offset;
};


gboolean swap_new       (SwapFile * swap,
                         gchar *    filename);
gboolean swap_delete    (SwapFile * swap);
gboolean swap_open      (SwapFile * swap);
gboolean swap_close     (SwapFile * swap);
SwapTag  swap_alloc     (SwapFile * swap,
                         gint       size);
gboolean swap_free      (SwapFile * swap,
                         SwapTag    tag);
gboolean swap_read      (SwapFile * swap,
                         SwapTag    tag,
                         gchar *    buffer,
                         gint       size);
gboolean swap_write     (SwapFile * swap,
                         SwapTag    tag,
                         gchar *    buffer,
                         gint       size);

#endif
