#include <gthread.h>

#define ROUND_NUM 3
#define PHIL_NUM 5

#define CURR_NUM (GPOINTER_TO_UINT( g_thread_private_get( number_private ) ))
#define LEFT_FORK ( CURR_NUM==0 ? PHIL_NUM-1 : CURR_NUM - 1 )
#define RIGHT_FORK CURR_NUM
#define FORK_NUM(left) ((left) ? LEFT_FORK : RIGHT_FORK)
#define FORK_HOLDER(left) forks[ FORK_NUM(left) ]
#define FORK_MONITOR(left) g_monitor_new_for_resource( &FORK_HOLDER(left) )
#define FORK_NAME(left) ((left) ? "left" : "right")


int forks[ PHIL_NUM ]; /* just to get unique addresses */

GMonitor* common_start;
GThreadPrivate* number_private;

void 
take_fork( gboolean left )
{
  GMonitor *fork = FORK_MONITOR( left );
  g_monitor_enter( fork );
  FORK_HOLDER(left) = CURR_NUM;
  g_print("Philosopher %d: took %s fork.\n", CURR_NUM, FORK_NAME(left) );
  g_monitor_free( fork );
}

void 
release_fork( gboolean left )
{
  GMonitor *fork = FORK_MONITOR( left );

  /* make sure, I have the fork, I want to release */
  g_assert( FORK_HOLDER(left) == CURR_NUM ); 

  g_monitor_exit( fork );
  g_print("Philosopher %d: released %s fork.\n", CURR_NUM, FORK_NAME(left) );
  g_monitor_free( fork );
}

void 
dining_philosopher( gpointer number_in )
{
  guint round;
  g_thread_private_set( number_private, number_in );

  g_monitor_wait( common_start, 0 );

  g_print("Philosopher %d: going to table.\n", CURR_NUM);
  for( round = 0; round < ROUND_NUM; round++ )
    { 
      take_fork( CURR_NUM != 0 ); /* this asymetry is preventing a */
      take_fork( CURR_NUM == 0 ); /* deadlock, as all of you know */

      g_print("Philosopher %d: eating.\n", CURR_NUM);
      g_thread_sleep( 0 ); /* Yield to another thread */

      release_fork( FALSE );
      release_fork( TRUE );
      g_thread_sleep( 0 ); /* Yield to another thread */
    }
  g_print("Philosopher %d: leaving table.\n", CURR_NUM);
}

GThread* philosophers[PHIL_NUM];

int
main()
{
  guint i;
  common_start = g_monitor_new();
  number_private = g_thread_private_new(NULL);
  for( i = 0; i < PHIL_NUM; i++ )
    {
      philosophers[ i ] = g_thread_new( dining_philosopher, 
					GUINT_TO_POINTER( i ), 0 );
    }
  g_thread_sleep(100000); /* wait 1/10 sec for everyone to get ready */
  g_monitor_notify_all( common_start );
  for( i = 0; i < PHIL_NUM; i++ )
    {
      g_thread_join( philosophers[ i ] );  
    }
  g_monitor_free( common_start );
  return 0;
}

