/* Simple primitives for manipulating rectangles.*/

#ifndef RECT_H
#define RECT_H

#ifndef BOOL_DEFINED
#define BOOL_DEFINED
typedef int bool;
#define true 1
#define false 0
#endif

#ifndef POINT_DEFINED
#define POINT_DEFINED
typedef struct point {
  double x;
  double y;
} point;
#endif

typedef struct rect {
  double x0, y0;
  double x1, y1;
} rect;

/* Since rectangles are of fixed size, it is expected that they are
   statically allocated (i.e. on the stack). Functions on rectangles,
   however, will be defined in terms of pointers to rectangles.

   Functions with a rectangle return will have a "destination"
   rectangle pointer as the first argument. */

void rect_copy (rect *dest, const rect *src);
void rect_union (rect *dest, const rect *src1, const rect *src2);
void rect_intersect (rect *dest, const rect *src1, const rect *src2);
bool rect_empty (const rect *src);
bool point_inside (rect *rect, point *point);

#endif
