/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * gthread.c: BeOS thread system implementation
 * Copyright 1999 Richard Offer/Richard Hess, Silicon Graphics.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* 
 * MT safe
 */

#include <be/kernel/OS.h>

#define beos_print_error( name, num )				\
  g_error( "file %s: line %d (%s): error %s during %s",         \
           __FILE__, __LINE__, G_GNUC_PRETTY_FUNCTION,          \
           strerror((num)), #name )
 

static GMutex *
g_mutex_new_beos_impl (void)
{
  sem_id *sem;
  sem = g_new(sem_id, 1);

  if ((*sem = create_sem(1, "glibsem")) < B_OK)
    {
      beos_print_error(create_sem(), *sem);
    }
  return *sem;
}  

static void
g_mutex_free_beos_impl (GMutex * mutex)
{
  g_free((sem_id*)mutex);
}

static void
g_mutex_lock_beos_impl (GMutex * mutex)
{
  status_t status;

  if ((status = acquire_sem(*((sem_id*)mutex))) != B_OK)
      beos_print_error(acquire_sem(), status);
}

static gboolean
g_mutex_trylock_beos_impl (GMutex * mutex)
{
  status_t status;
  sem_id sem;

  sem = *((sem_id*)mutex);

  status = acquire_sem_etc(sem, 1, B_TIMEOUT, 0.0);
  
  switch (status)
    {
      case B_OK:
        return TRUE;
      case B_WOULD_BLOCK:
      case B_TIMED_OUT:
        return FALSE;
      default:
        beos_print_error(acquire_sem_etc(), status);
        return FALSE;
    }
}

static void
g_mutex_unlock_beos_impl (GMutex * mutex)
{
  status_t status;
 
  if ((status = release_sem(*((sem_id*)mutex))) != B_OK)
    {
      beos_print_error(release_sem(), status);
      return;
    }
}

static GCond *
g_cond_new_beos_impl (void)
{
  
}

static void
g_cond_signal_beos_impl(GCond * cond)
{
}

static void
g_cond_broadcast_beos_impl(GCond *cond)
{
}

static void
g_cond_wait_beos_impl(GCond *cond, GMutex *mutex)
{
}

static gboolean
g_cond_timed_wait_beos_impl (GCond * cond,
			      GMutex * entered_mutex,
			      GTimeVal * abs_time)
{

}

static void
g_cond_free_beos_impl (GCond * cond)
{
}

static GPrivate *
g_private_new_beos_impl (GDestroyNotify destructor)
{

}

static void
g_private_set_beos_impl (GPrivate * private_key, gpointer value)
{
}

static gpointer
g_private_get_beos_impl (GPrivate * private_key)
{
}

static GThreadFunctions g_thread_functions_for_glib_use_default =
{
  g_mutex_new_beos_impl,
  g_mutex_lock_beos_impl,
  g_mutex_trylock_beos_impl,
  g_mutex_unlock_beos_impl,
  g_mutex_free_beos_impl,
  g_cond_new_beos_impl,
  g_cond_signal_beos_impl,
  g_cond_broadcast_beos_impl,
  g_cond_wait_beos_impl,
  g_cond_timed_wait_beos_impl,
  g_cond_free_beos_impl,
  g_private_new_beos_impl,
  g_private_get_beos_impl,
  g_private_set_beos_impl
};
