/*
 * FILE : ../_gtkbasemodule.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 2)
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#include <Python.h>
#include <gtk/gtk.h>

typedef struct {
  PyObject_HEAD
  GtkObject *obj;
} PyGtk_Object;

staticforward PyTypeObject PyGtk_Type;

#define PyGtk_Check(v) ((v)->ob_type == &PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->obj)

static PyObject *
PyGtk_New(GtkObject *go) {
  PyGtk_Object *self;

  self = (PyGtk_Object *)PyObject_NEW(PyGtk_Object, &PyGtk_Type);
  if (self == NULL)
    return NULL;
  self->obj = go;
  gtk_object_ref(self->obj);
  return (PyObject *)self;
}

static void 
PyGtk_dealloc(PyGtk_Object *self) {
  gtk_object_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtk_compare(PyGtk_Object *self, PyGtk_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *
PyGtk_repr(PyGtk_Object *self) {
  char buf[100];

  sprintf(buf, "<GtkObject of type %s at %lx>",
    gtk_type_name(PyGtk_Get(self)->klass->type), (long)PyGtk_Get(self));
  return PyString_FromString(buf);
}

static char PyGtk_Type__doc__[] = "This is the type of GTK Objects";

static PyTypeObject PyGtk_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,                              /*ob_size*/
  "GtkObject",                    /*tp_name*/
  sizeof(PyGtk_Object),           /*tp_basicsize*/
  0,                              /*tp_itemsize*/
  (destructor)PyGtk_dealloc,      /*tp_dealloc*/
  (printfunc)0,                   /*tp_print*/
  (getattrfunc)0,                 /*tp_getattr*/
  (setattrfunc)0,                 /*tp_setattr*/
  (cmpfunc)PyGtk_compare,         /*tp_compare*/
  (reprfunc)PyGtk_repr,           /*tp_repr*/
  0,                              /*tp_as_number*/
  0,                              /*tp_as_sequence*/
  0,                              /*tp_as_mapping*/
  (hashfunc)0,                    /*tp_hash*/
  (ternaryfunc)0,                 /*tp_call*/
  (reprfunc)0,                    /*tp_str*/
  0L,0L,0L,0L,
  PyGtk_Type__doc__
};

/* return 1 on failure */
gint PyGtkEnum_get_value(GtkType enum_type, PyObject *obj, int *val) {
  if (PyInt_Check(obj)) {
    *val = PyInt_AsLong(obj);
    return 0;
  } else if (PyString_Check(obj)) {
    GtkEnumValue *info = gtk_type_enum_find_value(enum_type,
						  PyString_AsString(obj));
    if (!info) {
      PyErr_SetString(PyExc_TypeError, "couldn't translate string");
      return 1;
    }
    *val = info->value;
    return 0;
  }
  PyErr_SetString(PyExc_TypeError, "enum values must be integers or strings");
  return 1;
}

gint PyGtkFlag_get_value(GtkType flag_type, PyObject *obj, int *val) {
  if (PyInt_Check(obj)) {
    *val = PyInt_AsLong(obj);
    return 0;
  } else if (PyString_Check(obj)) {
    GtkFlagValue *info = gtk_type_flags_find_value(flag_type,
						  PyString_AsString(obj));
    if (!info) {
      PyErr_SetString(PyExc_TypeError, "couldn't translate string");
      return 1;
    }
    *val = info->value;
    return 0;
  } else if (PyTuple_Check(obj)) {
    int i, len;
    PyObject *item;
    len = PyTuple_Size(obj);
    *val = 0;
    for (i = 0; i < len; i++) {
      item = PyTuple_GetItem(obj, i);
      if (PyInt_Check(item))
	*val |= PyInt_AsLong(item);
      else if (PyString_Check(item)) {
	GtkFlagValue *info = gtk_type_flags_find_value(flag_type,
						      PyString_AsString(item));
	if (!info) {
	  PyErr_SetString(PyExc_TypeError, "couldn't translate string");
	  return 1;
	}
	*val |= info->value;
      } else {
	PyErr_SetString(PyExc_TypeError,
			"tuple components must be ints or strings");
	return 1;
      }
    }
    return 0;
  }
  PyErr_SetString(PyExc_TypeError,
		  "flag values must be ints, strings or tuples");
  return 1;
}


typedef struct {
	PyObject_HEAD
	GtkAccelGroup *obj;
} PyGtkAccelGroup_Object;
staticforward PyTypeObject PyGtkAccelGroup_Type;

typedef struct {
	PyObject_HEAD
	GtkStyle *obj;
} PyGtkStyle_Object;
staticforward PyTypeObject PyGtkStyle_Type;

typedef struct {
	PyObject_HEAD
	GdkFont *obj;
} PyGdkFont_Object;
staticforward PyTypeObject PyGdkFont_Type;

typedef struct {
	PyObject_HEAD
	GdkColor obj;
} PyGdkColor_Object;
staticforward PyTypeObject PyGdkColor_Type;

typedef struct {
	PyObject_HEAD
	GdkEvent *obj;
	PyObject *attrs;
} PyGdkEvent_Object;
staticforward PyTypeObject PyGdkEvent_Type;

typedef struct {
        PyObject_HEAD
        GdkWindow *obj;
} PyGdkWindow_Object;
staticforward PyTypeObject PyGdkWindow_Type;

typedef struct {
        PyObject_HEAD
        GdkGC *obj;
} PyGdkGC_Object;
staticforward PyTypeObject PyGdkGC_Type;

typedef struct {
        PyObject_HEAD
	GdkColormap *obj;
} PyGdkColormap_Object;
staticforward PyTypeObject PyGdkColormap_Type;

#define PyGtkAccelGroup_Check(v) ((v)->ob_type == &PyGtkAccelGroup_Type)
#define PyGtkAccelGroup_Get(v) (((PyGtkAccelGroup_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == &PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == &PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == &PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == &PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == &PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == &PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)
#define PyGdkColormap_Check(v) ((v)->ob_type == &PyGdkColormap_Type)
#define PyGdkColormap_Get(v) (((PyGdkColormap_Object *)(v))->obj)


static PyObject *
PyGtkAccelGroup_New(GtkAccelGroup *obj) {
  PyGtkAccelGroup_Object  *self;

  self = (PyGtkAccelGroup_Object *)PyObject_NEW(PyGtkAccelGroup_Object ,
              &PyGtkAccelGroup_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_accel_group_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGtkStyle_New(GtkStyle *obj) {
  PyGtkStyle_Object *self;

  self = (PyGtkStyle_Object *)PyObject_NEW(PyGtkStyle_Object,
                                           &PyGtkStyle_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_style_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkFont_New(GdkFont *obj) {
  PyGdkFont_Object *self;

  self = (PyGdkFont_Object *)PyObject_NEW(PyGdkFont_Object, &PyGdkFont_Type);
  /*gdk_font_ref(obj);*/
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static PyObject *
PyGdkColor_New(GdkColor *obj) {
  PyGdkColor_Object *self;

  self = (PyGdkColor_Object *)PyObject_NEW(PyGdkColor_Object,&PyGdkColor_Type);
  if (self == NULL)
    return NULL;
  self->obj.pixel = obj->pixel;
  self->obj.red   = obj->red;
  self->obj.green = obj->green;
  self->obj.blue  = obj->blue;
  return (PyObject *)self;
}

static PyObject *
PyGdkWindow_New(GdkWindow *win) {
  PyGdkWindow_Object *self;

  self = (PyGdkWindow_Object *)PyObject_NEW(PyGdkWindow_Object,
					    &PyGdkWindow_Type);
  if (self == NULL)
    return NULL;
  self->obj = win;
  gdk_window_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkGC_New(GdkGC *gc) {
  PyGdkGC_Object *self;

  self = (PyGdkGC_Object *)PyObject_NEW(PyGdkGC_Object, &PyGdkGC_Type);
  if (self == NULL)
    return NULL;
  self->obj = gc;
  gdk_gc_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkColormap_New(GdkColormap *cmap) {
  PyGdkColormap_Object *self;

  self = (PyGdkColormap_Object *)PyObject_NEW(PyGdkColormap_Object,
					      &PyGdkColormap_Type);
  if (self == NULL)
    return NULL;
  self->obj = cmap;
  gdk_colormap_ref(self->obj);
  return (PyObject *)self;
}

static void
PyGtkAccelGroup_Dealloc(PyGtkAccelGroup_Object *self) {
  gtk_accel_group_unref(self->obj); 
  PyMem_DEL(self);
}

static int
PyGtkAccelGroup_Compare(PyGtkAccelGroup_Object *self,
                            PyGtkAccelGroup_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGtkAccelGroup_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkAccelGroup",
  sizeof(PyGtkAccelGroup_Object),
  0,
  (destructor)PyGtkAccelGroup_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGtkAccelGroup_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGtkStyle_Dealloc(PyGtkStyle_Object *self) {
  gtk_style_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtkStyle_Compare(PyGtkStyle_Object *self, PyGtkStyle_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *PyGtkStyle_GetAttr(PyGtkStyle_Object *self, char *attr) {
  GtkStyle *style = self->obj;
  PyObject *ret;
  int i;

  if (!strcmp(attr, "__members__"))
    return Py_BuildValue("[sssssssssssssssssssss]", "base", "base_gc", "bg",
			 "bg_gc", "bg_pixmap", "black", "black_gc", "colormap",
			 "dark", "dark_gc", "fg", "fg_gc", "font", "light",
			 "light_gc", "mid", "mid_gc", "text", "text_gc",
			 "white", "white_gc");
  if (!strcmp(attr, "fg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->fg[i]));
    return ret;
  }
  if (!strcmp(attr, "bg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->bg[i]));
    return ret;
  }
  if (!strcmp(attr, "light")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->light[i]));
    return ret;
  }
  if (!strcmp(attr, "dark")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->dark[i]));
    return ret;
  }
  if (!strcmp(attr, "mid")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->mid[i]));
    return ret;
  }
  if (!strcmp(attr, "text")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->text[i]));
    return ret;
  }
  if (!strcmp(attr, "base")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->base[i]));
    return ret;
  }
  if (!strcmp(attr, "black"))
    return PyGdkColor_New(&style->black);
  if (!strcmp(attr, "white"))
    return PyGdkColor_New(&style->white);
  if (!strcmp(attr, "font")) {
    gdk_font_ref(style->font);
    return PyGdkFont_New(style->font);
  }
  if (!strcmp(attr, "fg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->fg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "bg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->bg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "light_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->light_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "dark_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->dark_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "mid_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->mid_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "text_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->text_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "base_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->base_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "black_gc"))
    return PyGdkGC_New(style->black_gc);
  if (!strcmp(attr, "white_gc"))
    return PyGdkGC_New(style->white_gc);
  if (!strcmp(attr, "bg_pixmap")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i,PyGdkWindow_New(style->bg_pixmap[i]));
    return ret;
  }
  if (!strcmp(attr, "colormap")) {
    if (style->colormap)
      return PyGdkColormap_New(style->colormap);
    Py_INCREF(Py_None);
    return Py_None;
  }

  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static PyTypeObject PyGtkStyle_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkStyle",
  sizeof(PyGtkStyle_Object),
  0,
  (destructor)PyGtkStyle_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGtkStyle_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGtkStyle_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkFont_Dealloc(PyGdkFont_Object *self) {
  gdk_font_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkFont_Width(PyGdkFont_Object *self, PyObject *args) {
  char *text;
  int length;

  if (!PyArg_ParseTuple(args, "s#:GdkFont.width", &text, &length))
    return NULL;
  return PyInt_FromLong(gdk_text_width(self->obj, text, length));
}

static PyObject *
PyGdkFont_Measure(PyGdkFont_Object *self, PyObject *args) {
  char *text;
  int length;

  if (!PyArg_ParseTuple(args, "s#:GdkFont.measure", &text, &length))
    return NULL;
  return PyInt_FromLong(gdk_text_measure(self->obj, text, length));
}

static PyObject *
PyGdkFont_Height(PyGdkFont_Object *self, PyObject *args) {
  char *text;
  int length;

  if (!PyArg_ParseTuple(args, "s#:GdkFont.height", &text, &length))
    return NULL;
  return PyInt_FromLong(gdk_text_height(self->obj, text, length));
}

static PyMethodDef PyGdkFont_methods[] = {
  {"width",   (PyCFunction)PyGdkFont_Width,   METH_VARARGS, NULL},
  {"measure", (PyCFunction)PyGdkFont_Measure, METH_VARARGS, NULL},
  {"height",  (PyCFunction)PyGdkFont_Height,  METH_VARARGS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkFont_GetAttr(PyGdkFont_Object *self, char *key) {
  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sss]", "ascent", "descent", "type");
  if (!strcmp(key, "ascent"))
    return PyInt_FromLong(self->obj->ascent);
  if (!strcmp(key, "descent"))
    return PyInt_FromLong(self->obj->descent);
  if (!strcmp(key, "type"))
    return PyInt_FromLong(self->obj->type);
  return Py_FindMethod(PyGdkFont_methods, (PyObject *)self, key);
}

static int
PyGdkFont_Compare(PyGdkFont_Object *self, PyGdkFont_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkFont_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkFont",
  sizeof(PyGdkFont_Object),
  0,
  (destructor)PyGdkFont_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkFont_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkFont_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColor_Dealloc(PyGdkColor_Object *self) {
  PyMem_DEL(self);
}

static PyObject *
PyGdkColor_GetAttr(PyGdkColor_Object *self, char *key) {
  if (!strcmp(key, "red"))
    return PyInt_FromLong(self->obj.red);
  if (!strcmp(key, "green"))
    return PyInt_FromLong(self->obj.green);
  if (!strcmp(key, "blue"))
    return PyInt_FromLong(self->obj.blue);
  if (!strcmp(key, "pixel"))
    return PyInt_FromLong(self->obj.pixel);
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static int
PyGdkColor_Compare(PyGdkColor_Object *self, PyGdkColor_Object *v) {
  if (self->obj.pixel == v->obj.pixel) return 0;
  if (self->obj.pixel > v->obj.pixel) return -1;
  return 1;
}

static PyObject *
PyGdkColor_Repr(PyGdkColor_Object *self) {
  char buf[80];

  g_snprintf(buf, 79, "<GdkColor (%hu, %hu, %hu)>", self->obj.red,
	     self->obj.green, self->obj.blue);
  return PyString_FromString(buf);
}

static PyTypeObject PyGdkColor_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColor",
  sizeof(PyGdkColor_Object),
  0,
  (destructor)PyGdkColor_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkColor_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkColor_Compare,
  (reprfunc)PyGdkColor_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static PyObject *
PyGdkEvent_New(GdkEvent *obj) {
  PyGdkEvent_Object *self;
  PyObject *v;

  if (obj == NULL) {
    Py_INCREF(Py_None);
    return Py_None;
  }
  self = (PyGdkEvent_Object *)PyObject_NEW(PyGdkEvent_Object,&PyGdkEvent_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  self->attrs = PyDict_New();
  PyDict_SetItemString(self->attrs, "type", v=PyInt_FromLong(obj->type));
  Py_DECREF(v);
  PyDict_SetItemString(self->attrs, "window", v=PyGdkWindow_New(
						obj->any.window));
  Py_DECREF(v);
  PyDict_SetItemString(self->attrs, "send_event", v=PyInt_FromLong(
    obj->any.send_event));
  Py_DECREF(v);
  /* XXX Does anyone need the window attribute?? */
  switch(obj->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
      PyDict_SetItemString(self->attrs, "area", v=Py_BuildValue("(iiii)",
        obj->expose.area.x, obj->expose.area.y, obj->expose.area.width,
        obj->expose.area.height));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "count", v=PyInt_FromLong(
        obj->expose.count));
      Py_DECREF(v);
      break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->motion.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"x",v=PyFloat_FromDouble(obj->motion.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"y",v=PyFloat_FromDouble(obj->motion.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "pressure", v=PyFloat_FromDouble(
        obj->motion.pressure));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "xtilt", v=PyFloat_FromDouble(
        obj->motion.xtilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "ytilt", v=PyFloat_FromDouble(
        obj->motion.ytilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->motion.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "is_hint", v=PyInt_FromLong(
        obj->motion.is_hint));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->motion.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->motion.deviceid));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x_root", v=PyFloat_FromDouble(
        obj->motion.x_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y_root", v=PyFloat_FromDouble(
        obj->motion.y_root));
      Py_DECREF(v);
      break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->button.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"x",v=PyFloat_FromDouble(obj->button.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs,"y",v=PyFloat_FromDouble(obj->button.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "pressure", v=PyFloat_FromDouble(
        obj->button.pressure));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "xtilt", v=PyFloat_FromDouble(
        obj->button.xtilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "ytilt", v=PyFloat_FromDouble(
        obj->button.ytilt));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->button.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "button", v=PyInt_FromLong(
        obj->button.button));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->button.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->button.deviceid));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x_root", v=PyFloat_FromDouble(
        obj->button.x_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y_root", v=PyFloat_FromDouble(
        obj->button.y_root));
      Py_DECREF(v);
      break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
							obj->key.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->key.state));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "keyval", v=PyInt_FromLong(
        obj->key.keyval));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "string", v=PyString_FromStringAndSize(
        obj->key.string, obj->key.length));
      Py_DECREF(v);
      break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
      PyDict_SetItemString(self->attrs, "subwindow", v=PyGdkWindow_New(
						obj->crossing.subwindow));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
						obj->crossing.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x", v=PyFloat_FromDouble(
						obj->crossing.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y", v=PyFloat_FromDouble(
						obj->crossing.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "x_root", v=PyFloat_FromDouble(
						obj->crossing.x_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y_root", v=PyFloat_FromDouble(
						obj->crossing.y_root));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "mode", v=PyInt_FromLong(
						obj->crossing.mode));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "detail", v=PyInt_FromLong(
        obj->crossing.detail));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "focus", v=PyInt_FromLong(
						obj->crossing.focus));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
						obj->crossing.state));
      Py_DECREF(v);
      break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
      PyDict_SetItemString(self->attrs, "_in", v=PyInt_FromLong(
        obj->focus_change.in));
      Py_DECREF(v);
      break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
      PyDict_SetItemString(self->attrs, "x", v=PyInt_FromLong(obj->configure.x));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "y", v=PyInt_FromLong(obj->configure.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "width", v=PyInt_FromLong(
        obj->configure.width));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "height", v=PyInt_FromLong(
        obj->configure.height));
      Py_DECREF(v);
      break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
      PyDict_SetItemString(self->attrs, "atom", v=PyInt_FromLong(
        obj->property.atom));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->property.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->property.state));
      Py_DECREF(v);
      break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
      PyDict_SetItemString(self->attrs, "selection", v=PyInt_FromLong(
        obj->selection.selection));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "target", v=PyInt_FromLong(
        obj->selection.target));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "property", v=PyInt_FromLong(
        obj->selection.property));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->selection.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->selection.time));
      Py_DECREF(v);
      break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
      PyDict_SetItemString(self->attrs, "time", v=PyInt_FromLong(
        obj->proximity.time));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "source", v=PyInt_FromLong(
        obj->proximity.source));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "deviceid", v=PyInt_FromLong(
        obj->proximity.deviceid));
      Py_DECREF(v);
      break;
    case GDK_DRAG_BEGIN:        /*GdkEventDragBegin         dragbegin*/
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dragbegin.u.flags.protocol_version));
      Py_DECREF(v);
      break;
    case GDK_DRAG_REQUEST:      /*GdkEventDragRequest       dragrequest*/
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dragrequest.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "sendreply", v=PyInt_FromLong(
        obj->dragrequest.u.flags.sendreply));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "willaccept", v=PyInt_FromLong(
        obj->dragrequest.u.flags.willaccept));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "delete_data", v=PyInt_FromLong(
        obj->dragrequest.u.flags.delete_data));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "senddata", v=PyInt_FromLong(
        obj->dragrequest.u.flags.senddata));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "isdrop", v=PyInt_FromLong(
        obj->dragrequest.isdrop));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "drop_coords", v=Py_BuildValue("(ii)",
        obj->dragrequest.drop_coords.x, obj->dragrequest.drop_coords.y));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_type", v=PyString_FromString(
        obj->dragrequest.data_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "timestamp", v=PyInt_FromLong(
        obj->dragrequest.timestamp));
      Py_DECREF(v);
      break;
    case GDK_DROP_ENTER:        /*GdkEventDropEnter         dropenter*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropenter.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropenter.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "sendreply", v=PyInt_FromLong(
        obj->dropenter.u.flags.sendreply));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "extended_typelist", v=PyInt_FromLong(
        obj->dropenter.u.flags.extended_typelist));
      Py_DECREF(v);
      break;
    case GDK_DROP_LEAVE:        /*GdkEventDropLeave         dropleave*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropleave.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropleave.u.flags.protocol_version));
      Py_DECREF(v);
      break;
    case GDK_DROP_DATA_AVAIL:   /*GdkEventDropDataAvailable dropdataavailable*/
      PyDict_SetItemString(self->attrs, "requestor", v=PyInt_FromLong(
        obj->dropdataavailable.requestor));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "protocol_version", v=PyInt_FromLong(
        obj->dropdataavailable.u.flags.protocol_version));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "isdrop", v=PyInt_FromLong(
        obj->dropdataavailable.u.flags.isdrop));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_type", v=PyString_FromString(
        obj->dropdataavailable.data_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data", v=PyString_FromStringAndSize(
        obj->dropdataavailable.data, obj->dropdataavailable.data_numbytes));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "timestamp", v=PyInt_FromLong(
        obj->dropdataavailable.timestamp));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "coords", v=Py_BuildValue("(ii)",
        obj->dropdataavailable.coords.x, obj->dropdataavailable.coords.y));
      Py_DECREF(v);
      break;
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
      PyDict_SetItemString(self->attrs, "message_type", v=PyInt_FromLong(
        obj->client.message_type));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data_format", v=PyInt_FromLong(
        obj->client.data_format));
      Py_DECREF(v);
      PyDict_SetItemString(self->attrs, "data", v=PyString_FromStringAndSize(
        obj->client.data.b, 20));
      Py_DECREF(v);
      break;
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
      PyDict_SetItemString(self->attrs, "state", v=PyInt_FromLong(
        obj->visibility.state));
      Py_DECREF(v);
      break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
      break;
    case GDK_OTHER_EVENT:
    default:
      break;
  }
  return (PyObject *)self;
}

static void
PyGdkEvent_Dealloc(PyGdkEvent_Object *self) {
  Py_XDECREF(self->attrs);
  PyMem_DEL(self);
}

static PyObject *
PyGdkEvent_GetAttr(PyGdkEvent_Object *self, char *attr) {
  PyObject *ret;
  ret = PyDict_GetItemString(self->attrs, attr);
  if (ret != NULL) {
    Py_INCREF(ret);
    return ret;
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static int
PyGdkEvent_Compare(PyGdkEvent_Object *self, PyGdkEvent_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkEvent_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkEvent",
  sizeof(PyGdkEvent_Object),
  0,
  (destructor)PyGdkEvent_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkEvent_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkEvent_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkWindow_Dealloc(PyGdkWindow_Object *self) {
  if (gdk_window_get_type(self->obj) == GDK_WINDOW_PIXMAP)
    gdk_pixmap_unref(self->obj);
  else
    gdk_window_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkWindow_Compare(PyGdkWindow_Object *self, PyGdkWindow_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *
PyGdkWindow_Repr(PyGdkWindow_Object *self) {
  char buf[100];
  if (gdk_window_get_type(self->obj) == GDK_WINDOW_PIXMAP)
    sprintf(buf, "<GdkPixmap at %lx>", (long)PyGdkWindow_Get(self));
  else
    sprintf(buf, "<GdkWindow at %lx>", (long)PyGdkWindow_Get(self));
  return PyString_FromString(buf);
}

static PyObject *
PyGdkWindow_NewGC(PyGdkWindow_Object *self, PyObject *args, PyObject *kws) {
  int i = 0;
  PyObject *key, *value;
  char *strkey;
  GdkGCValues values;
  GdkGCValuesMask mask = 0;
  GdkGC *gc;

  if (kws != NULL)
    while (PyDict_Next(kws, &i, &key, &value)) {
      strkey = PyString_AsString(key);
      if (!strcmp(strkey, "foreground")) {
	if (!PyGdkColor_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "foreground argument takes a GdkColor");
	  return NULL;
	}
	mask |= GDK_GC_FOREGROUND;
	values.foreground.red = PyGdkColor_Get(value)->red;
	values.foreground.green = PyGdkColor_Get(value)->green;
	values.foreground.blue = PyGdkColor_Get(value)->blue;
	values.foreground.pixel = PyGdkColor_Get(value)->pixel;
      } else if (!strcmp(strkey, "background")) {
	if (!PyGdkColor_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "background argument takes a GdkColor");
	  return NULL;
	}
	mask |= GDK_GC_BACKGROUND;
	values.background.red = PyGdkColor_Get(value)->red;
	values.background.green = PyGdkColor_Get(value)->green;
	values.background.blue = PyGdkColor_Get(value)->blue;
	values.background.pixel = PyGdkColor_Get(value)->pixel;
      } else if (!strcmp(strkey, "font")) {
	if (!PyGdkFont_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "font argument takes a GdkFont");
	  return NULL;
	}
	mask |= GDK_GC_FONT;
	values.font = PyGdkFont_Get(value);
      } else if (!strcmp(strkey, "tile")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "tile argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_TILE;
	values.tile = PyGdkWindow_Get(value);
      } else if (!strcmp(strkey, "stipple")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "stipple argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_STIPPLE;
	values.stipple = PyGdkWindow_Get(value);
      } else if (!strcmp(strkey, "clip_mask")) {
	if (!PyGdkWindow_Check(value)) {
	  PyErr_SetString(PyExc_TypeError, "clip_mask argument takes a GdkPixmap");
	  return NULL;
	}
	mask |= GDK_GC_CLIP_MASK;
	values.clip_mask = PyGdkWindow_Get(value);
      } else {
	int i = 0;
#ifndef offsetof
#define offsetof(type, member) ( (int) &((type*)0)->member)
#endif
#define OFF(x) offsetof(GdkGCValues, x)
	static struct {char *name;GdkGCValuesMask mask;int offs; } others[] = {
	  {"function", GDK_GC_FUNCTION, OFF(function)},
	  {"fill",     GDK_GC_FILL,     OFF(fill)},
	  {"subwindow_mode", GDK_GC_SUBWINDOW, OFF(subwindow_mode)},
	  {"ts_x_origin", GDK_GC_TS_X_ORIGIN, OFF(ts_x_origin)},
	  {"ts_y_origin", GDK_GC_TS_Y_ORIGIN, OFF(ts_y_origin)},
	  {"clip_x_origin", GDK_GC_CLIP_X_ORIGIN, OFF(clip_x_origin)},
	  {"clip_y_origin", GDK_GC_CLIP_Y_ORIGIN, OFF(clip_y_origin)},
	  {"graphics_exposures", GDK_GC_EXPOSURES, OFF(graphics_exposures)},
	  {"line_width", GDK_GC_LINE_WIDTH, OFF(line_width)},
	  {"line_style", GDK_GC_LINE_STYLE, OFF(line_style)},
	  {"cap_style", GDK_GC_CAP_STYLE, OFF(cap_style)},
	  {"join_style", GDK_GC_JOIN_STYLE, OFF(join_style)},
	  {NULL, 0, 0}
	};
#undef OFF
	while (others[i].name != NULL) {
	  if (!strcmp(strkey, others[i].name)) {
	    if (!PyInt_Check(value)) {
	      char buf[80];
	      g_snprintf(buf, 79, "%s argument expects an integer",
			 others[i].name);
	      PyErr_SetString(PyExc_TypeError, buf);
	      return NULL;
	    }
	    mask |= others[i].mask;
	    *((int *)((char *)&values + others[i].offs)) = PyInt_AsLong(value);
	    break;
	  }
	  i++;
	}
	if (others[i].name == NULL) {
	  PyErr_SetString(PyExc_TypeError, "unknown argument");
	  return NULL;
	}
      }
    }
  if (!PyArg_ParseTuple(args, ":GdkWindow.new_gc"))
    return NULL;
  gc = gdk_gc_new_with_values(PyGdkWindow_Get(self), &values, mask);
  value = PyGdkGC_New(gc);
  gdk_gc_unref(gc);
  return value;
}

static PyMethodDef PyGdkWindow_methods[] = {
  {"new_gc", (PyCFunction)PyGdkWindow_NewGC, METH_VARARGS|METH_KEYWORDS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkWindow_GetAttr(PyGdkWindow_Object *self, char *key) {
  GdkWindow *win = PyGdkWindow_Get(self);
  gint x, y;
  GdkModifierType p_mask;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sssssssssss]", "children", "colormap", "height",
			 "parent", "pointer", "pointer_state", "toplevel",
			 "type", "width", "x", "y");
  if (!strcmp(key, "width")) {
    gdk_window_get_size(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "height")) {
    gdk_window_get_size(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "x")) {
    gdk_window_get_position(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "y")) {
    gdk_window_get_position(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "colormap"))
    return PyGdkColormap_New(gdk_window_get_colormap(win));
  if (!strcmp(key, "pointer")) {
    gdk_window_get_pointer(win, &x, &y, NULL);
    return Py_BuildValue("(ii)", x, y);
  }
  if (!strcmp(key, "pointer_state")) {
    gdk_window_get_pointer(win, NULL, NULL, &p_mask);
    return PyInt_FromLong(p_mask);
  }
  if (!strcmp(key, "parent"))
    return PyGdkWindow_New(gdk_window_get_parent(win));
  if (!strcmp(key, "toplevel"))
    return PyGdkWindow_New(gdk_window_get_toplevel(win));
  if (!strcmp(key, "children")) {
    GList *children, *tmp;
    PyObject *ret;
    children = gdk_window_get_children(win);
    ret = PyList_New(0);
    for (tmp = children; tmp != NULL; tmp = tmp->next)
      PyList_Append(ret, PyGdkWindow_New(tmp->data));
    g_list_free(children);
    return ret;
  }
  if (!strcmp(key, "type"))
    return PyInt_FromLong(gdk_window_get_type(win));
  return Py_FindMethod(PyGdkWindow_methods, (PyObject *)self, key);
}

static PyTypeObject PyGdkWindow_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkWindow",
  sizeof(PyGdkWindow_Object),
  0,
  (destructor)PyGdkWindow_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkWindow_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkWindow_Compare,
  (reprfunc)PyGdkWindow_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkGC_Dealloc(PyGdkGC_Object *self) {
  gdk_gc_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkGC_GetAttr(PyGdkGC_Object *self, char *key) {
  GdkGCValues gc;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[ssssssssssssssssss]", "background", "cap_style",
			 "clip_mask", "clip_x_origin", "clip_y_origin",
			 "fill", "font", "foreground", "function",
			 "graphics_exposures", "join_style", "line_style",
			 "line_width", "stipple", "sub_window", "tile",
			 "ts_x_origin", "ts_y_origin");
  gdk_gc_get_values(self->obj, &gc);
  if (!strcmp(key, "foreground")) return PyGdkColor_New(&(gc.foreground));
  if (!strcmp(key, "background")) return PyGdkColor_New(&(gc.background));
  if (!strcmp(key, "font")) return PyGdkFont_New(gc.font);
  if (!strcmp(key, "function")) return PyInt_FromLong(gc.function);
  if (!strcmp(key, "fill")) return PyInt_FromLong(gc.fill);
  if (!strcmp(key, "tile")) {
    if (gc.tile != NULL) return PyGdkWindow_New(gc.tile);
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "stipple")) {
    if (gc.stipple != NULL) return PyGdkWindow_New(gc.stipple);
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "clip_mask")) {
    if (gc.clip_mask!=NULL) return PyGdkWindow_New(gc.clip_mask);
    Py_INCREF(Py_None); return Py_None;
  }
  if (!strcmp(key, "subwindow_mode"))
    return PyInt_FromLong(gc.subwindow_mode);
  if (!strcmp(key, "ts_x_origin")) return PyInt_FromLong(gc.ts_x_origin);
  if (!strcmp(key, "ts_y_origin")) return PyInt_FromLong(gc.ts_y_origin);
  if (!strcmp(key, "clip_x_origin")) return PyInt_FromLong(gc.clip_x_origin);
  if (!strcmp(key, "clip_y_origin")) return PyInt_FromLong(gc.clip_y_origin);
  if (!strcmp(key, "graphics_exposures"))
    return PyInt_FromLong(gc.graphics_exposures);
  if (!strcmp(key, "line_width")) return PyInt_FromLong(gc.line_width);
  if (!strcmp(key, "line_style")) return PyInt_FromLong(gc.line_style);
  if (!strcmp(key, "cap_style")) return PyInt_FromLong(gc.cap_style);
  if (!strcmp(key, "join_style")) return PyInt_FromLong(gc.join_style);
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static int
PyGdkGC_SetAttr(PyGdkGC_Object *self, char *key, PyObject *value) {
  GdkGC *gc = self->obj;

  if (value == NULL) {
    PyErr_SetString(PyExc_TypeError, "can't delete attributes");
    return -1;
  }
  if (PyInt_Check(value)) {
    int i = PyInt_AsLong(value);
    GdkGCValues v;
    gdk_gc_get_values(gc, &v);
    if (!strcmp(key, "function")) gdk_gc_set_function(gc, i);
    else if (!strcmp(key, "fill")) gdk_gc_set_fill(gc, i);
    else if (!strcmp(key, "subwindow_mode")) gdk_gc_set_subwindow(gc, i);
    else if (!strcmp(key, "ts_x_origin"))
      gdk_gc_set_ts_origin(gc, i, v.ts_y_origin);
    else if (!strcmp(key, "ts_y_origin"))
      gdk_gc_set_ts_origin(gc, v.ts_x_origin, i);
    else if (!strcmp(key, "clip_x_origin"))
      gdk_gc_set_clip_origin(gc, i, v.clip_y_origin);
    else if (!strcmp(key, "clip_y_origin"))
      gdk_gc_set_clip_origin(gc, v.clip_x_origin, i);
    else if (!strcmp(key, "graphics_exposures")) gdk_gc_set_exposures(gc, i);
    else if (!strcmp(key, "line_width"))
      gdk_gc_set_line_attributes(gc, i,v.line_style,v.cap_style,v.join_style);
    else if (!strcmp(key, "line_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,i,v.cap_style,v.join_style);
    else if (!strcmp(key, "cap_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,v.line_style,i,v.join_style);
    else if (!strcmp(key, "join_style"))
      gdk_gc_set_line_attributes(gc, v.line_width,v.line_style,v.cap_style,i);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkColor_Check(value)) {
    GdkColor *c = PyGdkColor_Get(value);
    if (!strcmp(key, "foreground")) gdk_gc_set_foreground(gc, c);
    else if (!strcmp(key, "background")) gdk_gc_set_background(gc, c);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkFont_Check(value)) {
    if (!strcmp(key, "font")) gdk_gc_set_font(gc, PyGdkFont_Get(value));
    else{
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else if (PyGdkWindow_Check(value) || value == Py_None) {
    GdkWindow *w = (value==Py_None)?NULL:PyGdkWindow_Get(value);
    if (!strcmp(key, "tile")) gdk_gc_set_tile(gc, w);
    else if (!strcmp(key, "stipple")) gdk_gc_set_stipple(gc, w);
    else if (!strcmp(key, "clip_mask")) gdk_gc_set_clip_mask(gc, w);
    else {
      PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"type mismatch");
      return -1;
  }
  return 0;
}

static int
PyGdkGC_Compare(PyGdkGC_Object *self, PyGdkGC_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkGC_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkGC",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkGC_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkGC_GetAttr,
  (setattrfunc)PyGdkGC_SetAttr,
  (cmpfunc)PyGdkGC_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColormap_Dealloc(PyGdkColormap_Object *self) {
  gdk_colormap_unref(self->obj);
  PyMem_DEL(self);
}

static PyObject *
PyGdkColor_Alloc(PyGdkColormap_Object *self, PyObject *args) {
  GdkColor color = {0, 0, 0, 0};
  gchar *color_name;
  if (!PyArg_ParseTuple(args, "iii:GdkColormap.alloc",
			&(color.red), &(color.green), &(color.blue))) {
    PyErr_Clear();
    if (!PyArg_ParseTuple(args, "s:GdkColormap.alloc", &color_name))
      return NULL;
    if (!gdk_color_parse(color_name, &color)) {
      PyErr_SetString(PyExc_TypeError, "unable to parse color specification");
      return NULL;
    }
  }
  if (!gdk_color_alloc(self->obj, &color)) {
    PyErr_SetString(PyExc_RuntimeError, "couldn't allocate color");
    return NULL;
  }
  return PyGdkColor_New(&color);
}

static PyMethodDef PyGdkColormap_methods[] = {
  {"alloc", (PyCFunction)PyGdkColor_Alloc, METH_VARARGS, NULL},
  {NULL, 0, 0, NULL}
};

static PyObject *
PyGdkColormap_GetAttr(PyObject *self, char *key) {
  return Py_FindMethod(PyGdkColormap_methods, self, key);
}

static int
PyGdkColormap_Compare(PyGdkColormap_Object *self, PyGdkColormap_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static int
PyGdkColormap_Length(PyGdkColormap_Object *self) {
  return self->obj->size;
}

static PyObject *
PyGdkColormap_GetItem(PyGdkColormap_Object *self, int pos) {
  if (pos < 0 || pos >= self->obj->size) {
    PyErr_SetString(PyExc_IndexError, "index out of range");
    return NULL;
  }
  return PyGdkColor_New(&(self->obj->colors[pos]));
}

static PyObject *
PyGdkColormap_GetSlice(PyGdkColormap_Object *self, int lo, int up) {
  PyObject *ret;
  int i;

  if (lo < 0) lo = 0;
  if (up > self->obj->size) up = self->obj->size;
  if (up < lo) up = lo;

  ret = PyTuple_New(up - lo);
  if (ret == NULL) return NULL;
  for (i = lo; i < up; i++)
    PyTuple_SetItem(ret, i - lo, PyGdkColor_New(&(self->obj->colors[i])));
  return ret;
}

static PySequenceMethods PyGdkColormap_Sequence = {
  (inquiry)PyGdkColormap_Length,
  (binaryfunc)0,
  (intargfunc)0,
  (intargfunc)PyGdkColormap_GetItem,
  (intintargfunc)PyGdkColormap_GetSlice,
  (intobjargproc)0,
  (intintobjargproc)0
};

static PyTypeObject PyGdkColormap_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColormap",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkColormap_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkColormap_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkColormap_Compare,
  (reprfunc)0,
  0,
  &PyGdkColormap_Sequence,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

/* This file contains routines used to convert GtkArg structures and arrays
 * to and from Python objects.  This code is used for the callback marshalling
 * code, signal handling, and GtkObject properties (gtk_object_[gs]et).
 *
 * It is collected here, so I don't accidentally reproduce it elsewhere in
 * pygtk. */

/* destroy notify for PyObject */
static void PyGtk_DestroyNotify(gpointer data) {
  Py_DECREF((PyObject *)data);
}
static void PyGtk_CallbackMarshal(GtkObject *o, gpointer d, int nargs,
				  GtkArg *args);
static PyObject *GtkArgs_AsTuple(int nparams, GtkArg *args);
static int GtkArgs_FromSequence(GtkArg *args, int nparams, PyObject *seq);

/* create a GtkArg from a PyObject, using the GTK_VALUE_* routines.
 * returns -1 if it couldn't set the argument. */
static int GtkArg_FromPyObject(GtkArg *arg, PyObject *obj) {
  PyObject *tmp;
  switch (GTK_FUNDAMENTAL_TYPE(arg->type)) {
  case GTK_TYPE_NONE:
  case GTK_TYPE_INVALID:
    GTK_VALUE_INT(*arg) = 0;
    break;
  case GTK_TYPE_BOOL:
    if (tmp = PyNumber_Int(obj))
      GTK_VALUE_BOOL(*arg) = (PyInt_AsLong(tmp) != 0);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_CHAR:
    if (tmp = PyObject_Str(obj))
      GTK_VALUE_CHAR(*arg) = PyString_AsString(tmp)[0];
    else 
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_ENUM:
    if (PyGtkEnum_get_value(arg->type, obj, &(GTK_VALUE_ENUM(*arg))))
      return -1;
    break;
  case GTK_TYPE_FLAGS:
    if (PyGtkFlag_get_value(arg->type, obj, &(GTK_VALUE_FLAGS(*arg))))
      return -1;
    break;
  case GTK_TYPE_INT:
    if (tmp = PyNumber_Int(obj))
      GTK_VALUE_INT(*arg) = PyInt_AsLong(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_UINT:
    if (tmp = PyNumber_Int(obj))
      GTK_VALUE_UINT(*arg) = PyInt_AsLong(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_LONG:
    if (tmp = PyNumber_Int(obj))
      GTK_VALUE_LONG(*arg) = PyInt_AsLong(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_ULONG:
    if (tmp = PyNumber_Int(obj))
      GTK_VALUE_ULONG(*arg) = PyInt_AsLong(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_FLOAT:
    if (tmp = PyNumber_Float(obj))
      GTK_VALUE_FLOAT(*arg) = PyFloat_AsDouble(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_STRING:
    if (tmp = PyObject_Str(obj))
      GTK_VALUE_STRING(*arg) = PyString_AsString(tmp);
    else
      return -1;
    Py_DECREF(tmp);
    break;
  case GTK_TYPE_OBJECT:
    if (PyGtk_Check(obj))
      GTK_VALUE_OBJECT(*arg) = PyGtk_Get(obj);
    else
      return -1;
    break;
  case GTK_TYPE_BOXED:
    if (arg->type == GTK_TYPE_ACCEL_GROUP) {
      if (PyGtkAccelGroup_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGtkAccelGroup_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_STYLE) {
      if (PyGtkStyle_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGtkStyle_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_GDK_EVENT) {
      if (PyGdkEvent_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGdkEvent_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_GDK_FONT) {
      if (PyGdkFont_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGdkFont_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_GDK_COLOR) {
      if (PyGdkColor_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGdkColor_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_GDK_WINDOW) {
      if (PyGdkWindow_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGdkWindow_Get(obj);
      else
	return -1;
    } else if (arg->type == GTK_TYPE_GDK_COLORMAP) {
      if (PyGdkColormap_Check(obj))
	GTK_VALUE_BOXED(*arg) = PyGdkColormap_Get(obj);
      else
	return -1;
    } else
      return -1;
    break;
  case GTK_TYPE_POINTER:
    if (PyCObject_Check(obj))
      GTK_VALUE_BOXED(*arg) = PyCObject_AsVoidPtr(obj);
    else
      return -1;
    break;
  case GTK_TYPE_FOREIGN:
    Py_INCREF(obj);
    GTK_VALUE_FOREIGN(*arg).data = obj;
    GTK_VALUE_FOREIGN(*arg).notify = PyGtk_DestroyNotify;
    break;
  case GTK_TYPE_SIGNAL:
    if (PyCallable_Check(obj)) {
      Py_INCREF(obj);
      GTK_VALUE_SIGNAL(*arg).f = NULL;
      GTK_VALUE_SIGNAL(*arg).d = obj;
    } else
      return -1;
    break;
  case GTK_TYPE_CALLBACK:
    if (PyCallable_Check(obj)) {
      Py_INCREF(obj);
      GTK_VALUE_CALLBACK(*arg).marshal =
	(GtkCallbackMarshal)PyGtk_CallbackMarshal;
      GTK_VALUE_CALLBACK(*arg).data = obj;
      GTK_VALUE_CALLBACK(*arg).notify = PyGtk_DestroyNotify;
    } else
      return -1;
    break;
  case GTK_TYPE_ARGS:
  case GTK_TYPE_C_CALLBACK:
    fprintf(stderr, "unsupported type");
    g_assert_not_reached();
    return -1;
  }
  return 0;
}

/* convert a GtkArg structure to a PyObject, using the GTK_VALUE_* routines.
 * conversion is always possible. */
static PyObject *GtkArg_AsPyObject(GtkArg *arg) {
  switch (GTK_FUNDAMENTAL_TYPE(arg->type)) {
  case GTK_TYPE_INVALID:
  case GTK_TYPE_NONE:
    Py_INCREF(Py_None);
    return Py_None;
  case GTK_TYPE_CHAR:
    return PyString_FromStringAndSize(&GTK_VALUE_CHAR(*arg), 1);
  case GTK_TYPE_BOOL:
    return PyInt_FromLong(GTK_VALUE_BOOL(*arg));
  case GTK_TYPE_ENUM:
  case GTK_TYPE_FLAGS:
  case GTK_TYPE_INT:
    return PyInt_FromLong(GTK_VALUE_INT(*arg));
  case GTK_TYPE_UINT:
    return PyInt_FromLong(GTK_VALUE_UINT(*arg));
  case GTK_TYPE_LONG:
    return PyInt_FromLong(GTK_VALUE_LONG(*arg));
  case GTK_TYPE_ULONG:
    return PyInt_FromLong(GTK_VALUE_ULONG(*arg));
  case GTK_TYPE_FLOAT:
    return PyFloat_FromDouble(GTK_VALUE_FLOAT(*arg));
  case GTK_TYPE_DOUBLE:
    return PyFloat_FromDouble(GTK_VALUE_DOUBLE(*arg));
  case GTK_TYPE_STRING:
    if (GTK_VALUE_STRING(*arg) != NULL)
      return PyString_FromString(GTK_VALUE_STRING(*arg));
    else {
      Py_INCREF(Py_None);
      return Py_None;
    }
  case GTK_TYPE_ARGS:
    return GtkArgs_AsTuple(GTK_VALUE_ARGS(*arg).n_args,
			   GTK_VALUE_ARGS(*arg).args);
  case GTK_TYPE_OBJECT:
    return PyGtk_New(GTK_VALUE_OBJECT(*arg));
  case GTK_TYPE_POINTER:
    return PyCObject_FromVoidPtr(GTK_VALUE_POINTER(*arg), NULL);
  case GTK_TYPE_BOXED:
    if (arg->type == GTK_TYPE_ACCEL_GROUP)
      return PyGtkAccelGroup_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_STYLE)
      return PyGtkStyle_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_EVENT)
      return PyGdkEvent_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_FONT)
      return PyGdkFont_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_COLOR)
      return PyGdkColor_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_WINDOW)
      return PyGdkWindow_New(GTK_VALUE_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_COLORMAP)
      return PyGdkColormap_New(GTK_VALUE_BOXED(*arg));
    else
      return PyCObject_FromVoidPtr(GTK_VALUE_BOXED(*arg), NULL);
  case GTK_TYPE_FOREIGN:
    Py_INCREF((PyObject *)GTK_VALUE_FOREIGN(*arg).data);
    return (PyObject *)GTK_VALUE_FOREIGN(*arg).data;
  case GTK_TYPE_CALLBACK:
    Py_INCREF((PyObject *)GTK_VALUE_CALLBACK(*arg).data);
    return (PyObject *)GTK_VALUE_CALLBACK(*arg).data;
  case GTK_TYPE_SIGNAL:
    Py_INCREF((PyObject *)GTK_VALUE_SIGNAL(*arg).d);
    return (PyObject *)GTK_VALUE_SIGNAL(*arg).d;
  default:
    g_assert_not_reached();
    break;
  }
  return NULL;
}

/* set a GtkArg structure's data from a PyObject, using the GTK_RETLOC_*
 * routines.  If it can't make the conversion, set the return to a zero
 * equivalent. */
static void GtkRet_FromPyObject(GtkArg *ret, PyObject *py_ret) {
  PyObject *tmp;
  switch (GTK_FUNDAMENTAL_TYPE(ret->type)) {
  case GTK_TYPE_NONE:
  case GTK_TYPE_INVALID:
    break;
  case GTK_TYPE_BOOL:
    if (tmp = PyNumber_Int(py_ret)) {
      *GTK_RETLOC_BOOL(*ret) = (PyInt_AsLong(tmp) != 0);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_BOOL(*ret) = FALSE;
    break;
  case GTK_TYPE_CHAR:
    if (tmp = PyObject_Str(py_ret)) {
      *GTK_RETLOC_CHAR(*ret) = PyString_AsString(tmp)[0];
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_CHAR(*ret) = '\0';
    break;
  case GTK_TYPE_ENUM:
    if (PyGtkEnum_get_value(ret->type, py_ret, GTK_RETLOC_ENUM(*ret))) {
      PyErr_Clear();
      *GTK_RETLOC_ENUM(*ret) = 0;
    }
    break;
  case GTK_TYPE_FLAGS:
    if (PyGtkFlag_get_value(ret->type, py_ret, GTK_RETLOC_FLAGS(*ret))) {
      PyErr_Clear();
      *GTK_RETLOC_FLAGS(*ret) = 0;
    }
    break;
  case GTK_TYPE_INT:
    if (tmp = PyNumber_Int(py_ret)) {
      *GTK_RETLOC_INT(*ret) = PyInt_AsLong(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_INT(*ret) = 0;
    break;
  case GTK_TYPE_UINT:
    if (tmp = PyNumber_Int(py_ret)) {
      *GTK_RETLOC_UINT(*ret) = PyInt_AsLong(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_UINT(*ret) = 0;
    break;
  case GTK_TYPE_LONG:
    if (tmp = PyNumber_Int(py_ret)) {
      *GTK_RETLOC_LONG(*ret) = PyInt_AsLong(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_LONG(*ret) = 0;
    break;
  case GTK_TYPE_ULONG:
    if (tmp = PyNumber_Int(py_ret)) {
      *GTK_RETLOC_ULONG(*ret) = PyInt_AsLong(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_ULONG(*ret) = 0;
    break;
  case GTK_TYPE_FLOAT:
    if (tmp = PyNumber_Float(py_ret)) {
      *GTK_RETLOC_FLOAT(*ret) = PyFloat_AsDouble(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_FLOAT(*ret) = 0;
    break;
  case GTK_TYPE_DOUBLE:
    if (tmp = PyNumber_Float(py_ret)) {
      *GTK_RETLOC_DOUBLE(*ret) = PyFloat_AsDouble(tmp);
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_DOUBLE(*ret) = 0;
    break;
  case GTK_TYPE_STRING:
    if (tmp = PyObject_Str(py_ret)) {
      *GTK_RETLOC_STRING(*ret) = g_strdup(PyString_AsString(py_ret));
      Py_DECREF(tmp);
    } else
      *GTK_RETLOC_STRING(*ret) = NULL;
    break;
  case GTK_TYPE_OBJECT:
    if (PyGtk_Check(py_ret))
      *GTK_RETLOC_OBJECT(*ret) = PyGtk_Get(py_ret);
    else
      *GTK_RETLOC_OBJECT(*ret) = NULL;
    break;
  case GTK_TYPE_BOXED:
    if (ret->type == GTK_TYPE_ACCEL_GROUP) {
      if (PyGtkAccelGroup_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGtkAccelGroup_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_STYLE) {
      if (PyGtkStyle_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGtkStyle_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_GDK_EVENT) {
      if (PyGdkEvent_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGdkEvent_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_GDK_FONT) {
      if (PyGdkFont_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGdkFont_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_GDK_COLOR) {
      if (PyGdkColor_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGdkColor_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_GDK_WINDOW) {
      if (PyGdkWindow_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGdkWindow_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else if (ret->type == GTK_TYPE_GDK_COLORMAP) {
      if (PyGdkColormap_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyGdkColormap_Get(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    } else {
      if (PyCObject_Check(py_ret))
	*GTK_RETLOC_BOXED(*ret) = PyCObject_AsVoidPtr(py_ret);
      else
	*GTK_RETLOC_BOXED(*ret) = NULL;
    }
    break;
  case GTK_TYPE_POINTER:
    if (PyCObject_Check(py_ret))
      *GTK_RETLOC_POINTER(*ret) = PyCObject_AsVoidPtr(py_ret);
    else
      *GTK_RETLOC_POINTER(*ret) = NULL;
  default:
    g_assert_not_reached();
    break;
  }
}

/* convert a GtkArg structure to a PyObject, using the GTK_RETLOC_* routines.
 * conversion is always possible. */
static PyObject *GtkRet_AsPyObject(GtkArg *arg) {
  switch (GTK_FUNDAMENTAL_TYPE(arg->type)) {
  case GTK_TYPE_INVALID:
  case GTK_TYPE_NONE:
    Py_INCREF(Py_None);
    return Py_None;
  case GTK_TYPE_CHAR:
    return PyString_FromStringAndSize(GTK_RETLOC_CHAR(*arg), 1);
  case GTK_TYPE_BOOL:
    return PyInt_FromLong(*GTK_RETLOC_BOOL(*arg));
  case GTK_TYPE_ENUM:
  case GTK_TYPE_FLAGS:
  case GTK_TYPE_INT:
    return PyInt_FromLong(*GTK_RETLOC_INT(*arg));
  case GTK_TYPE_UINT:
    return PyInt_FromLong(*GTK_RETLOC_UINT(*arg));
  case GTK_TYPE_LONG:
    return PyInt_FromLong(*GTK_RETLOC_LONG(*arg));
  case GTK_TYPE_ULONG:
    return PyInt_FromLong(*GTK_RETLOC_ULONG(*arg));
  case GTK_TYPE_FLOAT:
    return PyFloat_FromDouble(*GTK_RETLOC_FLOAT(*arg));
  case GTK_TYPE_DOUBLE:
    return PyFloat_FromDouble(*GTK_RETLOC_DOUBLE(*arg));
  case GTK_TYPE_STRING:
    if (*GTK_RETLOC_STRING(*arg) != NULL)
      return PyString_FromString(*GTK_RETLOC_STRING(*arg));
    else {
      Py_INCREF(Py_None);
      return Py_None;
    }
  case GTK_TYPE_ARGS:
    break;
  case GTK_TYPE_OBJECT:
    return PyGtk_New(*GTK_RETLOC_OBJECT(*arg));
  case GTK_TYPE_POINTER:
    return PyCObject_FromVoidPtr(*GTK_RETLOC_POINTER(*arg), NULL);
  case GTK_TYPE_BOXED:
    if (arg->type == GTK_TYPE_ACCEL_GROUP)
      return PyGtkAccelGroup_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_STYLE)
      return PyGtkStyle_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_EVENT)
      return PyGdkEvent_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_FONT)
      return PyGdkFont_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_COLOR)
      return PyGdkColor_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_WINDOW)
      return PyGdkWindow_New(*GTK_RETLOC_BOXED(*arg));
    else if (arg->type == GTK_TYPE_GDK_COLORMAP)
      return PyGdkColormap_New(*GTK_RETLOC_BOXED(*arg));
    else
      return PyCObject_FromVoidPtr(*GTK_RETLOC_BOXED(*arg), NULL);
  default:
    g_assert_not_reached();
    break;
  }
  return NULL;
}

/* convert the GtkArg array ARGS to a python tuple */
static PyObject *GtkArgs_AsTuple(int nparams, GtkArg *args) {
  PyObject *tuple, *item;
  int i;

  tuple = PyTuple_New(nparams);
  for (i = 0; i < nparams; i++) {
    item = GtkArg_AsPyObject(&args[i]);
    if (item == NULL) {
      Py_INCREF(Py_None);
      item = Py_None;
    }
    PyTuple_SetItem(tuple, i, item);
  }
  return tuple;
}

/* converts a Python sequence to a GtkArg array.  Returns -1 if the sequence
 * doesn't match the specification in ARGS */
static int GtkArgs_FromSequence(GtkArg *args, int nparams, PyObject *seq) {
  PyObject *item;
  int i;
  if (!PySequence_Check(seq))
    return -1;
  for (i = 0; i < nparams; i++) {
    item = PySequence_GetItem(seq, i);
    if (GtkArg_FromPyObject(&args[i], item)) {
      gchar buf[512];
      if (args[i].name == NULL)
	g_snprintf(buf, 511, "argument %d: expected %s, %s found", i+1,
		   gtk_type_name(args[i].type), item->ob_type->tp_name);
      else
	g_snprintf(buf, 511, "argument %s: expected %s, %s found",
		   args[i].name, gtk_type_name(args[i].type),
		   item->ob_type->tp_name);
      PyErr_SetString(PyExc_TypeError, buf);
      return -1;
    }
  }
  return 0;
}

/* generic callback marshal */
static void PyGtk_CallbackMarshal(GtkObject *o, gpointer data, int nargs,
				  GtkArg *args) {
  PyObject *func = data, *ret, *a, *params;

  a = GtkArgs_AsTuple(nargs, args);
  if (a == NULL) {
    PyErr_Clear();
    fprintf(stderr, "can't decode params -- callback not run\n");
    return;
  }
  if (o == NULL)
    params = a;
  else {
    /* prepend object to argument list */
    ret = PyTuple_New(1);
    PyTuple_SetItem(ret, 0, PyGtk_New(o));
    params = PySequence_Concat(ret, a);
    Py_DECREF(ret); Py_DECREF(a);
  }
  ret = PyObject_CallObject(func, params);
  Py_DECREF(params);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    return;
  }
  GtkRet_FromPyObject(&args[nargs], ret);
  Py_DECREF(ret);
}



static
void PyGtk_SignalMarshal(GtkObject *object, /*gpointer*/ PyObject *func,
                       int nparams, GtkArg *args, GtkType *arg_types,
                                                 GtkType return_type) {
    PyObject *arg_list, *params, *ret;

    ret = PyTuple_New(1);
    PyTuple_SetItem(ret, 0, PyGtk_New(object));
    arg_list = GtkArgs_AsTuple(nparams, args);
    params = PySequence_Concat(ret, arg_list);
    Py_DECREF(ret);
    Py_DECREF(arg_list);
    if (PyTuple_Check(func)) { /* extra arguments given with func */
      arg_list = PyTuple_GetItem(func, 1);
      func = PyTuple_GetItem(func, 0);
      if (PyTuple_Check(arg_list)) {
	ret = params;
	params = PySequence_Concat(ret, arg_list);
	Py_DECREF(ret);
      }
    }
    ret = PyObject_CallObject(func, params);
    Py_DECREF(params);

    if (ret == NULL) {
        PyErr_Print();
	PyErr_Clear();
	return;
    }
    GtkArg_FromPyObject(&args[nparams], ret);
    Py_DECREF(ret);
}

static
void PyGtk_SignalDestroy(/*gpointer*/ PyObject *func) {
    Py_DECREF(func);
}

#include "sysmodule.h"

/* simple callback handler -- this one actually looks at the return type */
/* used for timeout and idle functions */
static void PyGtk_HandlerMarshal(gpointer a, PyObject *func, int nargs,
                                                          GtkArg *args) {
  PyObject *ret;

  ret = PyObject_CallObject(func, NULL);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
    *GTK_RETLOC_BOOL(args[0]) = FALSE;
    return;
  }
  if (ret == Py_None || (PyInt_Check(ret) && PyInt_AsLong(ret) == 0))
    *GTK_RETLOC_BOOL(args[0]) = FALSE;
  else
    *GTK_RETLOC_BOOL(args[0]) = TRUE;
  Py_DECREF(ret);
}

/* callback for input handlers */
static void PyGtk_InputMarshal(gpointer a, PyObject *func, int nargs,
			                                GtkArg *args) {
  PyObject *tuple, *ret;

  tuple = Py_BuildValue("(ii)", GTK_VALUE_INT(args[0]),
			GTK_VALUE_FLAGS(args[1]));
  ret = PyObject_CallObject(func, tuple);
  Py_DECREF(tuple);
  if (ret == NULL) {
    PyErr_Print();
    PyErr_Clear();
  } else
    Py_DECREF(ret);
}

static PyObject *_wrap_gtk_signal_connect(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func, *extra = NULL;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO|O!:gtk_signal_connect", &PyGtk_Type,
			  &obj, &name, &func, &PyTuple_Type, &extra))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    if (extra) {
      PyObject *tmp;
      tmp = PyTuple_New(2);
      PyTuple_SetItem(tmp, 0, func);
      Py_INCREF(extra);
      PyTuple_SetItem(tmp, 1, extra);
      func = tmp;
    }
    signum = gtk_signal_connect(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}

static PyObject *_wrap_gtk_signal_connect_after(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func, *extra = NULL;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO|O!:gtk_signal_connect_after",
                    &PyGtk_Type, &obj, &name, &func, &PyTuple_Type, &extra))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    if (extra) {
      PyObject *tmp;
      tmp = PyTuple_New(2);
      PyTuple_SetItem(tmp, 0, func);
      Py_INCREF(extra);
      PyTuple_SetItem(tmp, 1, extra);
      func = tmp;
    }
    signum = gtk_signal_connect_after(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}

static PyObject *_wrap_gtk_signal_disconnect(PyObject *self, PyObject *args) {
  PyObject * _resultobj;
  int  id;
  PyObject *obj;

  self = self;
  if(!PyArg_ParseTuple(args,"O!i:gtk_signal_disconnect", &PyGtk_Type, &obj,
		       &id))
    return NULL;
  gtk_signal_disconnect(PyGtk_Get(obj), id);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *_wrap_gtk_signal_disconnect_by_data(PyObject *self, PyObject *args) {
  PyObject *obj;
  PyObject *data;
  
  self = self;
  if(!PyArg_ParseTuple(args,"O!O:gtk_signal_disconnect_by_data",
		       &PyGtk_Type, &obj, &data)) 
    return NULL;
  gtk_signal_disconnect_by_data(PyGtk_Get(obj), data);
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *_wrap_gtk_signal_handler_block(PyObject *self, PyObject *args) {
    int id;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!i:gtk_signal_handler_block", &PyGtk_Type,
			 &obj, &id)) 
        return NULL;
    gtk_signal_handler_block(PyGtk_Get(obj), id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_handler_block_by_data(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *data;

    if(!PyArg_ParseTuple(args,"O!O:gtk_signal_handler_block_by_data",
			 &PyGtk_Type, &obj, &data)) 
        return NULL;
    gtk_signal_handler_block_by_data(PyGtk_Get(obj), data);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_handler_unblock(PyObject *self, PyObject *args) {
    int  id;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!i:gtk_signal_handler_unblock", &PyGtk_Type,
			 &obj, &id)) 
        return NULL;
    gtk_signal_handler_unblock(PyGtk_Get(obj), id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_handler_unblock_by_data(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *data;

    if(!PyArg_ParseTuple(args,"O!O:gtk_signal_handler_unblock_by_data",
			 &PyGtk_Type, &obj, &data)) 
        return NULL;
    gtk_signal_handler_unblock_by_data(PyGtk_Get(obj), data);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_handlers_destroy(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_signal_handlers_destroy", &PyGtk_Type,
			 &obj)) 
        return NULL;
    gtk_signal_handlers_destroy(PyGtk_Get(obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_emit_stop_by_name(PyObject *self, PyObject *args) {
    char *name;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!s:gtk_signal_emit_stop_by_name", &PyGtk_Type,
			 &obj, &name)) 
        return NULL;
    gtk_signal_emit_stop_by_name(PyGtk_Get(obj), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_signal_emitv_by_name(PyObject *self, PyObject *args) {
  guint signal_id, i, nparams;
  GtkSignalQuery *query;
  GtkArg *params;
  PyObject *obj, *py_params;
  gchar *name, buf[sizeof(GtkArg)]; /* large enough to hold any return value */

  if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_emitv_by_name", &PyGtk_Type,
			&obj, &name, &py_params))
    return NULL;
  if (!PySequence_Check(py_params)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }

  signal_id = gtk_signal_lookup(name, GTK_OBJECT_TYPE(PyGtk_Get(obj)));
  if (signal_id <= 0) {
    PyErr_SetString(PyExc_KeyError, "can't find signal in classes ancestry");
    return NULL;
  }
  query = gtk_signal_query(signal_id);
  params = g_new(GtkArg, query->nparams + 1);
  nparams = query->nparams;
  for (i = 0; i < nparams; i++) {
    params[i].type = query->params[i];
    params[i].name = NULL;
  }
  params[i].type = query->return_val;
  params[i].name = NULL;
  GTK_RETLOC_POINTER(params[i]) = buf; /* buffer to hold return value */
  g_free(query);
  if (GtkArgs_FromSequence(params, query->nparams, py_params)) {
    g_free(params);
    return NULL;
  }
  gtk_signal_emitv(PyGtk_Get(obj), signal_id, params);
  obj = GtkRet_AsPyObject(&params[nparams]);
  g_free(params);
  if (obj == NULL) { Py_INCREF(Py_None); obj = Py_None; }
  return obj;
}

static PyObject * _wrap_gtk_init(PyObject *self, PyObject *args) {
    PyObject *av;
    int argc, i;
    char **argv;

    /* ensure that this procedure only gets run once */
    static int run_already = 0;
    if (run_already) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    run_already = 1;

    if (!PyArg_ParseTuple(args, ":gtk_init"))
        return NULL;

    av = PySys_GetObject("argv");
    argc = PyList_Size(av);
    argv = malloc(argc * sizeof(char *));
    for (i = 0; i < argc; i++)
        argv[i] = strdup(PyString_AsString(PyList_GetItem(av, i)));

    gtk_init(&argc, &argv);
    PySys_SetArgv(argc, argv);

    if (argv != NULL) {
        for (i = 0; i < argc; i++)
            if (argv[i] != NULL)
                free(argv[i]);
        free(argv);
    }
    gtk_signal_set_funcs((GtkSignalMarshal)PyGtk_SignalMarshal,
                         (GtkSignalDestroy)PyGtk_SignalDestroy);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_exit(PyObject *self, PyObject *args) {
    int  code;

    if(!PyArg_ParseTuple(args,"i:gtk_exit", &code)) 
        return NULL;
    gtk_exit(code);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_main(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_main")) 
        return NULL;
    gtk_main();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_main_quit(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_main_quit")) 
        return NULL;
    gtk_main_quit();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_main_iteration(PyObject *self, PyObject *args) {
    int block = 1;

    if(!PyArg_ParseTuple(args,"|i:gtk_main_iteration", &block)) 
        return NULL;
    return PyInt_FromLong(gtk_main_iteration_do(block));
}

static PyObject *_wrap_gtk_grab_add(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_grab_add", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_grab_add(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_grab_remove(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_grab_remove", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_grab_remove(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_set_locale(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_set_locale")) 
        return NULL;
    return PyString_FromString(gtk_set_locale());
}

static PyObject *
_wrap_gtk_timeout_add(PyObject *self, PyObject *args) {
    guint32 interval;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_timeout_add", &interval, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "second arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_timeout_add_interp(interval,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback,
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *_wrap_gtk_timeout_remove(PyObject *self, PyObject *args) {
    int id;

    if(!PyArg_ParseTuple(args,"i:gtk_timeout_remove", &id)) 
        return NULL;
    gtk_timeout_remove(id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_idle_add(PyObject *self, PyObject *args) {
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "O:gtk_idle_add", &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_interp(
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *
_wrap_gtk_idle_add_priority(PyObject *self, PyObject *args) {
    int p;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_idle_add_priority", &p, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_full(p, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *_wrap_gtk_idle_remove(PyObject *self, PyObject *args) {
    int id;

    if(!PyArg_ParseTuple(args,"i:gtk_idle_remove",&id)) 
        return NULL;
    gtk_idle_remove(id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_idle_remove_function(PyObject *self, PyObject *args) {
    PyObject *data;

    if(!PyArg_ParseTuple(args,"O:gtk_idle_remove_function", &data)) 
        return NULL;
    gtk_idle_remove_by_data(data);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_quit_add(PyObject *self, PyObject *args) {
    int main_level;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_quit_add", &main_level, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_quit_add_full(main_level, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *_wrap_gtk_quit_remove(PyObject *self, PyObject *args) {
    int id;

    if(!PyArg_ParseTuple(args,"i:gtk_quit_remove",&id)) 
        return NULL;
    gtk_quit_remove(id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_quit_remove_function(PyObject *self, PyObject *args) {
    PyObject *data;

    if(!PyArg_ParseTuple(args,"O:gtk_quit_remove_function",&data)) 
        return NULL;
    gtk_quit_remove_by_data(data);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_quit_add_destroy(PyObject *self, PyObject *args) {
    int level;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"iO!:gtk_quit_add_destroy", &level,
			 &PyGtk_Type, &obj)) 
        return NULL;
    gtk_quit_add_destroy(level, PyGtk_Get(obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_input_add(PyObject *self, PyObject *args) {
    int source;
    GdkInputCondition condition;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iiO:gtk_input_add", &source, &condition,
			  &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "3rd arg not callable.");
	return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_input_add_full(source, condition, NULL,
			(GtkCallbackMarshal)PyGtk_InputMarshal, callback,
			(GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *_wrap_gtk_input_remove(PyObject *self, PyObject *args) {
    int id;

    if(!PyArg_ParseTuple(args,"i:gtk_input_remove",&id)) 
        return NULL;
    gtk_input_remove(id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_rc_init(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_rc_init")) 
        return NULL;
    gtk_rc_init();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_rc_parse(PyObject *self, PyObject *args) {
    char *file;

    if(!PyArg_ParseTuple(args,"s:gtk_rc_parse",&file)) 
        return NULL;
    gtk_rc_parse(file);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_rc_parse_string(PyObject *self, PyObject *args) {
    char *str;

    if(!PyArg_ParseTuple(args,"s:gtk_rc_parse_string",&str)) 
        return NULL;
    gtk_rc_parse_string(str);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_rc_get_style(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_rc_get_style",&PyGtk_Type, &obj)) 
        return NULL;
    return PyGtkStyle_New(gtk_rc_get_style(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_rc_add_widget_name_style(PyObject *self, PyObject *args) {
    char *name;
    PyObject *style;

    if(!PyArg_ParseTuple(args,"O!s:gtk_rc_add_widget_name_style",
			 &PyGtkStyle_Type, &style, &name)) 
        return NULL;
    gtk_rc_add_widget_name_style(PyGtkStyle_Get(style), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_rc_add_widget_class_style(PyObject *self, PyObject *args) {
    char * name;
    PyObject *style;

    if(!PyArg_ParseTuple(args,"O!s:gtk_rc_add_widget_class_style",
			 &PyGtkStyle_Type, &style, &name)) 
        return NULL;
    gtk_rc_add_widget_class_style(PyGtkStyle_Get(style), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static void PyGtk_object_set(GtkObject *o, PyObject *dict) {
    int i = 0;
    PyObject *key, *item;
    char *name, *err;
    GtkType obtype;
    GtkArg arg;
    GtkArgInfo *info;
 
    obtype = GTK_OBJECT_TYPE(o);

    while (PyDict_Next(dict, &i, &key, &item)) {
        if (!PyString_Check(key)) {
            fprintf(stderr, "Key not a string\n");
            continue;
        }
        name = PyString_AsString(key);
	err = gtk_object_arg_get_info(obtype, name, &info);
        if (info == NULL) {
            fprintf(stderr, err);
	    g_free(err);
            continue;
        }

        arg.type = info->type;
        arg.name = info->name;
	if (GtkArg_FromPyObject(&arg, item)) {
	  fprintf(stderr, "%s: expected %s, %s found\n", name,
		  gtk_type_name(arg.type), item->ob_type->tp_name);
	  continue;
	}
        gtk_object_setv(o, 1, &arg);
    }
}

static GtkArg *PyDict_AsGtkArgs(PyObject *dict, GtkType type, gint *nargs) {
    PyObject *key, *item;
    gint i = 0, pos;
    GtkArg *arg;
    GtkArgInfo *info;
    gchar *err, buf[128];

    gtk_type_class(type); /* initialise the class structure (and setup args) */
    *nargs = PyDict_Size(dict);
    arg = g_new(GtkArg, *nargs);
    pos = 0;
    while (PyDict_Next(dict, &i, &key, &item)) {
        if (!PyString_Check(key)) {
	    PyErr_SetString(PyExc_TypeError,"dictionary keys must be strings");
	    g_free(arg);
	    return NULL;
        }
	arg[pos].name = PyString_AsString(key);
	err = gtk_object_arg_get_info(type, arg[pos].name, &info);
	if (info == NULL) {
	    PyErr_SetString(PyExc_TypeError, err);
	    g_free(err);
	    g_free(arg);
	    return NULL;
	}
	arg[pos].type = info->type;
	arg[pos].name = info->name;
	if (GtkArg_FromPyObject(&(arg[pos]), item)) {
	    g_snprintf(buf, 255, "arg %s: expected type %s, found %s",
		       arg[pos].name, gtk_type_name(arg[pos].type),
		       item->ob_type->tp_name);
	    PyErr_SetString(PyExc_TypeError, buf);
	    g_free(arg);
	    return NULL;
	}
	pos++;
    }
    return arg;
}

static PyObject *_wrap_gtk_object_set(PyObject *self, PyObject *args) {
    PyObject *obj, *dict;
    GtkArg *arg;
    gint nargs;

    if (!PyArg_ParseTuple(args, "O!O!:gtk_object_set", &PyGtk_Type, &obj,
                  &PyDict_Type, &dict))
        return NULL;
    arg = PyDict_AsGtkArgs(dict, GTK_OBJECT_TYPE(PyGtk_Get(obj)), &nargs);
    if (arg == NULL && nargs != 0)
      return NULL;
    gtk_object_setv(PyGtk_Get(obj), nargs, arg);
    g_free(arg);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_object_new(PyObject *self, PyObject *args) {
    GtkType type;
    gint nargs, i;
    GtkArg *arg;
    PyObject *dict;
    GtkObject *obj;

    if (!PyArg_ParseTuple(args, "iO!:gtk_object_new", &type, &PyDict_Type,
			  &dict))
        return NULL;
    arg = PyDict_AsGtkArgs(dict, type, &nargs);
    if (arg == NULL && nargs != 0)
        return NULL;
    obj = gtk_object_newv(type, nargs, arg);
    g_free(arg);
    return PyGtk_New(obj);
}

static PyObject *_wrap_gtk_object_get(PyObject *self, PyObject *args) {
    PyGtk_Object *o;
    char *name;
    GtkArg garg;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s:gtk_object_get", &PyGtk_Type, &o, &name))
        return NULL;
    garg.name = name;
    gtk_object_getv(PyGtk_Get(o), 1, &garg);

    if (garg.type == GTK_TYPE_INVALID) {
        PyErr_SetString(PyExc_AttributeError, "invalid property");
        return NULL;
    }
    ret = GtkArg_AsPyObject(&garg);
    if (ret == NULL) {
      PyErr_SetString(PyExc_TypeError, "couldn't translate type");
      return NULL;
    }
    return ret;
}

static PyObject *_wrap_gtk_type_name(PyObject *self, PyObject *args) {
    int typeid;

    if(!PyArg_ParseTuple(args,"i:gtk_type_name",&typeid)) 
        return NULL;
    return PyString_FromString(gtk_type_name(typeid));
}

static PyObject *_wrap_gtk_type_from_name(PyObject *self, PyObject *args) {
    char *name;

    if(!PyArg_ParseTuple(args,"s:gtk_type_from_name",&name)) 
        return NULL;
    return PyInt_FromLong(gtk_type_from_name(name));
}

static PyObject *_wrap_GTK_CHECK_TYPE(PyObject *self, PyObject *args) {
    PyObject *obj;
    GtkType type;
    if (!PyArg_ParseTuple(args, "O!i:GTK_CHECK_TYPE", &PyGtk_Type,&obj,&type))
        return NULL;
    return PyInt_FromLong(GTK_CHECK_TYPE(PyGtk_Get(obj), type));
}

static PyObject *_wrap_gtk_object_get_type(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_object_get_type")) 
        return NULL;
    return PyInt_FromLong(gtk_object_get_type());
}

static PyObject *_wrap_GTK_OBJECT_FLAGS(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:GTK_OBJECT_FLAGS", &PyGtk_Type, &obj)) 
        return NULL;
    return PyInt_FromLong(GTK_OBJECT_FLAGS(PyGtk_Get(obj)));
}

static PyObject *_wrap_GTK_OBJECT_TYPE(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:GTK_OBJECT_TYPE", &PyGtk_Type, &obj)) 
        return NULL;
    return PyInt_FromLong(GTK_OBJECT_TYPE(PyGtk_Get(obj)));
}

static PyObject *_wrap_GTK_OBJECT_SET_FLAGS(PyObject *self, PyObject *args) {
    int  flags;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!i:GTK_OBJECT_SET_FLAGS", &PyGtk_Type,
			 &obj, &flags)) 
        return NULL;
    GTK_OBJECT_SET_FLAGS(PyGtk_Get(obj), flags);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_GTK_OBJECT_UNSET_FLAGS(PyObject *self, PyObject *args) {
    int flags;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!i:GTK_OBJECT_UNSET_FLAGS", &PyGtk_Type,
			 &obj, &flags)) 
        return NULL;
    GTK_OBJECT_UNSET_FLAGS(PyGtk_Get(obj), flags);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_object_set_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!sO:gtk_object_set_data", &PyGtk_Type,
			&obj, &key, &data))
		return NULL;
	Py_INCREF(data);
	gtk_object_set_data_full(PyGtk_Get(obj), key, data,
		(GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *_wrap_gtk_object_get_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!s:gtk_object_get_data", &PyGtk_Type,
			&obj, &key))
		return NULL;
	data = gtk_object_get_data(PyGtk_Get(obj), key);
	if (data != NULL) {
		Py_INCREF(data);
		return data;
	} else {
		Py_INCREF(Py_None);
		return Py_None;
	}
}

static PyObject *_wrap_gtk_object_remove_data(PyObject *self, PyObject *args) {
    char *key;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!s:gtk_object_remove_data", &PyGtk_Type,
			 &obj, &key)) 
        return NULL;
    gtk_object_remove_data(PyGtk_Get(obj), key);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_get_type(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_widget_get_type")) 
        return NULL;
    return PyInt_FromLong(gtk_widget_get_type());
}

static PyObject *_wrap_gtk_widget_get_window(PyObject *self, PyObject *args) {
    GdkWindow *win;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_window", &PyGtk_Type, &obj)) 
        return NULL;
    win = GTK_WIDGET(PyGtk_Get(obj))->window;
    if (win == NULL) {
        Py_INCREF(Py_None);
        return Py_None;
    } else
        return PyGdkWindow_New(win);
}

static PyObject *_wrap_gtk_widget_destroy(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_destroy", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_destroy(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_unparent(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_unparent", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_unparent(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_show(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_show", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_show(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_hide(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_hide", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_hide(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_show_all(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_show_all", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_show_all(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_show_now(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_show_now", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_show_now(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_hide_all(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_hide_all",&PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_hide_all(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_map(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_map", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_map(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_unmap(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_unmap", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_unmap(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_realize(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_realize", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_realize(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_unrealize(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_unrealize", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_unrealize(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_queue_draw(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_queue_draw", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_queue_draw(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_queue_resize(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_queue_resize", &PyGtk_Type,&obj)) 
        return NULL;
    gtk_widget_queue_resize(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_draw(PyObject *self, PyObject *args) {
    GdkRectangle rect;
    PyObject *obj;

    if (!PyArg_ParseTuple(args,"O!(iiii):gtk_widget_draw", &PyGtk_Type, &obj,
			 &(rect.x), &(rect.y), &(rect.width), &(rect.height)))
        return NULL;
    gtk_widget_draw(GTK_WIDGET(PyGtk_Get(obj)), &rect);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_draw_focus(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_draw_focus", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_draw_focus(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_draw_default(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_draw_default", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_draw_default(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_draw_children(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_draw_children", &PyGtk_Type,&obj))
        return NULL;
    gtk_widget_draw_children(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_size_request(PyObject *self, PyObject *args) {
    GtkRequisition requisition;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_size_request", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_size_request(GTK_WIDGET(PyGtk_Get(obj)), &requisition);
    return Py_BuildValue("(ii)", requisition.width, requisition.height);
}

static PyObject *_wrap_gtk_widget_size_allocate(PyObject *self, PyObject *args) {
    GtkAllocation allocation;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!(ii):gtk_widget_size_allocate", &PyGtk_Type,
			 &obj, &(allocation.x), &(allocation.y)))
        return NULL;
    gtk_widget_size_allocate(GTK_WIDGET(PyGtk_Get(obj)), &allocation);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_add_accelerator(PyObject *self, PyObject *args) {
    PyObject *obj;
    char *signame;
    PyObject *accel;
    int key;
    GdkModifierType mods;
    GtkAccelFlags flags;
    PyObject *py_mods;
    PyObject *py_flags;

    if(!PyArg_ParseTuple(args,"O!sO!iOO:gtk_widget_add_accelerator",
			 &PyGtk_Type,&obj, &signame, &PyGtkAccelGroup_Type,
			 &accel, &key, &py_mods, &py_flags)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mods,(gint *)&mods))
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_ACCEL_FLAGS, py_flags, (gint *)&flags))
        return NULL;
    gtk_widget_add_accelerator(GTK_WIDGET(PyGtk_Get(obj)), signame,
			       PyGtkAccelGroup_Get(accel), key, mods, flags);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_remove_accelerator(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *accel;
    int key;
    GdkModifierType mods;
    PyObject *py_mods;

    if(!PyArg_ParseTuple(args,"O!O!iO:gtk_widget_remove_accelerator",
			 &PyGtk_Type, &obj, &PyGtkAccelGroup_Type, &accel,
			 &key, &py_mods)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mods,(gint *)&mods))
        return NULL;
    gtk_widget_remove_accelerator(GTK_WIDGET(PyGtk_Get(obj)),
				  PyGtkAccelGroup_Get(accel), key, mods);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_remove_accelerators(PyObject *self, PyObject *args) {
    PyObject *obj;
    char *signame;
    int visible;

    if(!PyArg_ParseTuple(args,"O!si:gtk_widget_remove_accelerators",
			 &PyGtk_Type, &obj, &signame, &visible)) 
        return NULL;
    gtk_widget_remove_accelerators(GTK_WIDGET(PyGtk_Get(obj)), signame,
				   visible);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_freeze_accelerators(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_freeze_accelerators", &PyGtk_Type,
			 &obj)) 
        return NULL;
    gtk_widget_freeze_accelerators(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_thaw_accelerators(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_thaw_accelerators", &PyGtk_Type,
			 &obj)) 
        return NULL;
    gtk_widget_thaw_accelerators(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_event(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *event;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_event", &PyGtk_Type, &obj,
			 &PyGdkEvent_Type, &event)) 
        return NULL;
    return PyInt_FromLong(gtk_widget_event(GTK_WIDGET(PyGtk_Get(obj)),
					   PyGdkEvent_Get(event)));
}

static PyObject *_wrap_gtk_widget_activate(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_activate", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_activate(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_reparent(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *parent;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_reparent", &PyGtk_Type, &obj,
			 &PyGtk_Type, &parent)) 
        return NULL;
    gtk_widget_reparent(GTK_WIDGET(PyGtk_Get(obj)),
			GTK_WIDGET(PyGtk_Get(parent)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_popup(PyObject *self, PyObject *args) {
    PyObject *obj;
    int  x;
    int  y;

    if(!PyArg_ParseTuple(args,"O!ii:gtk_widget_popup",&PyGtk_Type, &obj,
			 &x, &y)) 
        return NULL;
    gtk_widget_popup(GTK_WIDGET(PyGtk_Get(obj)), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_intersect(PyObject *self, PyObject *args) {
    PyObject *obj;
    GdkRectangle area;
    GdkRectangle intersect;

    if(!PyArg_ParseTuple(args,"O!(iiii):gtk_widget_intersect", &PyGtk_Type,
			 &obj, &(area.x), &(area.y), &(area.width),
			 &(area.height))) 
        return NULL;
    if (gtk_widget_intersect(GTK_WIDGET(PyGtk_Get(obj)), &area, &intersect))
        return Py_BuildValue("(iiii)", intersect.x, intersect.y,
			     intersect.width, intersect.height);
    else {
        Py_INCREF(Py_None);
        return Py_None;
    }
}

static PyObject *_wrap_gtk_widget_basic(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_basic", &PyGtk_Type, &obj)) 
        return NULL;
    return PyInt_FromLong(gtk_widget_basic(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_grab_focus(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_grab_focus", &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_grab_focus(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_grab_default(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_grab_default", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_grab_default(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_name(PyObject *self, PyObject *args) {
    char *name;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!s:gtk_widget_set_name", &PyGtk_Type, &obj,
			 &name)) 
        return NULL;
    gtk_widget_set_name(GTK_WIDGET(PyGtk_Get(obj)), name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_get_name(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_name", &PyGtk_Type, &obj)) 
        return NULL;
    return PyString_FromString(
           gtk_widget_get_name(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_set_state(PyObject *self, PyObject *args) {
    PyObject *obj;
    GtkStateType state;
    PyObject *py_state;

    if(!PyArg_ParseTuple(args,"O!O:gtk_widget_set_state", &PyGtk_Type, &obj,
			 &py_state))
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_STATE_TYPE, py_state, (gint *)&state))
        return NULL;
    gtk_widget_set_state(GTK_WIDGET(PyGtk_Get(obj)), state);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_sensitive(PyObject *self, PyObject *args) {
    PyObject *obj;
    int sens;

    if(!PyArg_ParseTuple(args,"O!i:gtk_widget_set_sensitive", &PyGtk_Type,
			 &obj, &sens)) 
        return NULL;
    gtk_widget_set_sensitive(GTK_WIDGET(PyGtk_Get(obj)), sens);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_parent(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *parent;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_set_parent", &PyGtk_Type, &obj,
			 &PyGtk_Type, &parent)) 
        return NULL;
    gtk_widget_set_parent(GTK_WIDGET(PyGtk_Get(obj)),
			  GTK_WIDGET(PyGtk_Get(parent)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_parent_window(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *win;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_set_parent_window", &PyGtk_Type,
			 &obj, &PyGdkWindow_Type, &win)) 
        return NULL;
    gtk_widget_set_parent_window(GTK_WIDGET(PyGtk_Get(obj)),
				 PyGdkWindow_Get(win));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_get_parent_window(PyObject *self, PyObject *args) {
    PyObject *obj;
    GdkWindow *win;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_parent_window", &PyGtk_Type,
			 &obj)) 
        return NULL;
    win = gtk_widget_get_parent_window(GTK_WIDGET(PyGtk_Get(obj)));
    if (win == NULL) {
        Py_INCREF(Py_None);
        return Py_None;
    } else
        return PyGdkWindow_New(win);
}

static PyObject *_wrap_gtk_widget_set_style(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *style;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_set_style", &PyGtk_Type, &obj,
			 &PyGtkStyle_Type, &style))
        return NULL;
    gtk_widget_set_style(GTK_WIDGET(PyGtk_Get(obj)), PyGtkStyle_Get(style));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_rc_style(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_set_rc_style", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_set_rc_style(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_ensure_style(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_ensure_style", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_ensure_style(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_restore_default_style(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_restore_default_style",
			 &PyGtk_Type, &obj)) 
        return NULL;
    gtk_widget_restore_default_style(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_reset_rc_styles(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_reset_rc_styles", &PyGtk_Type,
			 &obj)) 
        return NULL;
    gtk_widget_reset_rc_styles(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_uposition(PyObject *self, PyObject *args) {
    PyObject *obj;
    int x;
    int y;

    if(!PyArg_ParseTuple(args,"O!ii:gtk_widget_set_uposition", &PyGtk_Type,
			 &obj, &x, &y)) 
        return NULL;
    gtk_widget_set_uposition(GTK_WIDGET(PyGtk_Get(obj)), x, y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_usize(PyObject *self, PyObject *args) {
    PyObject *obj;
    int width;
    int height;

    if(!PyArg_ParseTuple(args,"O!ii:gtk_widget_set_usize", &PyGtk_Type, &obj,
			 &width, &height)) 
        return NULL;
    gtk_widget_set_usize(GTK_WIDGET(PyGtk_Get(obj)), width, height);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_events(PyObject *self, PyObject *args) {
    PyObject *obj;
    int mask;
    PyObject *py_mask;

    if(!PyArg_ParseTuple(args,"O!O:gtk_widget_set_events", &PyGtk_Type, &obj,
			 &py_mask)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_EVENT_MASK, py_mask, &mask))
        return NULL;
    gtk_widget_set_events(GTK_WIDGET(PyGtk_Get(obj)), mask);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_extension_events(PyObject *self, PyObject *args) {
    PyObject *obj;
    GdkExtensionMode mode;
    PyObject *py_mode;

    if(!PyArg_ParseTuple(args,"O!O:gtk_widget_set_extension_events",
			 &PyGtk_Type, &obj, &py_mode)) 
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_GDK_EXTENSION_MODE, py_mode, (gint*)mode))
        return NULL;
    gtk_widget_set_extension_events(GTK_WIDGET(PyGtk_Get(obj)), mode);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_get_toplevel(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_toplevel", &PyGtk_Type, &obj))
        return NULL;
    return PyGtk_New((GtkObject *)gtk_widget_get_toplevel(
            GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_get_ancestor(PyObject *self, PyObject *args) {
    PyObject *obj;
    int type;

    if(!PyArg_ParseTuple(args,"O!i:gtk_widget_get_ancestor", &PyGtk_Type, &obj,
			 &type)) 
        return NULL;
    return PyGtk_New((GtkObject *)
            gtk_widget_get_ancestor(GTK_WIDGET(PyGtk_Get(obj)), type));
}

static PyObject *_wrap_gtk_widget_get_style(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_style", &PyGtk_Type, &obj)) 
        return NULL;
    return PyGtkStyle_New(gtk_widget_get_style(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_get_events(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_events", &PyGtk_Type, &obj)) 
        return NULL;
    return PyInt_FromLong(gtk_widget_get_events(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_get_extension_events(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_get_extension_events",
			 &PyGtk_Type, &obj)) 
        return NULL;
    return PyInt_FromLong(
            gtk_widget_get_extension_events(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *gtk_widget__get_pointer(PyObject *self, PyObject *args) {
  int x, y;
  PyObject *w;
  if (!PyArg_ParseTuple(args, "O!:gtk_widget_get_pointer", &PyGtk_Type, &w))
    return NULL;
  gtk_widget_get_pointer(GTK_WIDGET(PyGtk_Get(w)), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}

static PyObject *_wrap_gtk_widget_is_ancestor(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *ancestor;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_is_ancestor", &PyGtk_Type,
			 &obj, &PyGtk_Type, &ancestor)) 
        return NULL;
    return PyInt_FromLong(gtk_widget_is_ancestor(GTK_WIDGET(PyGtk_Get(obj)),
					GTK_WIDGET(PyGtk_Get(ancestor))));
}

static PyObject *_wrap_gtk_widget_is_child(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *child;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_widget_is_child", &PyGtk_Type, &obj,
			 &PyGtk_Type, &child)) 
        return NULL;
    return PyInt_FromLong(gtk_widget_is_child(GTK_WIDGET(PyGtk_Get(obj)),
					      GTK_WIDGET(PyGtk_Get(child))));
}

static PyObject *_wrap_gtk_widget_hide_on_delete(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_hide_on_delete", &PyGtk_Type,
			 &obj)) 
        return NULL;
    return PyInt_FromLong(
            gtk_widget_hide_on_delete(GTK_WIDGET(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_widget_push_style(PyObject *self, PyObject *args) {
    PyObject *style;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_push_style", &PyGtkStyle_Type,
			 &style)) 
        return NULL;
    gtk_widget_push_style(PyGtkStyle_Get(style));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_pop_style(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_widget_pop_style")) 
        return NULL;
    gtk_widget_pop_style();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_set_default_style(PyObject *self, PyObject *args) {
    PyObject *style;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_set_default_style",
			 &PyGtkStyle_Type, &style)) 
        return NULL;
    gtk_widget_set_default_style(PyGtkStyle_Get(style));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_shape_combine_mask(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *mask;
    int off_x;
    int off_y;

    if(!PyArg_ParseTuple(args,"O!O!ii:gtk_widget_shape_combine_mask",
			 &PyGtk_Type, &obj, &PyGdkWindow_Type, &mask,
			 &off_x, &off_y)) 
        return NULL;
    gtk_widget_shape_combine_mask(GTK_WIDGET(PyGtk_Get(obj)),
				  PyGdkWindow_Get(mask), off_x, off_y);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_widget_dnd_drag_add(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_widget_dnd_drag_add", &PyGtk_Type, &obj))
        return NULL;
    gtk_widget_dnd_drag_add(GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gtk_widget_dnd_drag_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iO:gtk_widget_dnd_drag_set", &PyGtk_Type,
			  &obj, &enable, &pylist))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drag_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,numtypes);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
_wrap_gtk_widget_dnd_drop_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, is_destructive, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iOi:gtk_widget_dnd_drop_set", &PyGtk_Type,
			  &obj, &enable, &pylist, &is_destructive))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drop_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,
			    numtypes, is_destructive);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
_wrap_gtk_widget_dnd_data_set(PyObject *self, PyObject *args) {
    PyGtk_Object *wid;
    PyGdkEvent_Object *event;
    char *string;
    int len;
    if (!PyArg_ParseTuple(args, "O!O!z#:gtk_widget_dnd_data_set", &PyGtk_Type,
			  &wid, &PyGdkEvent_Type, &event, &string, &len))
        return NULL;
    gtk_widget_dnd_data_set(GTK_WIDGET(PyGtk_Get(wid)), PyGdkEvent_Get(event),
			    (gpointer) string, len);
    Py_INCREF(Py_None);
    return Py_None;
}

static GtkArg *PyDict_AsContainerArgs(PyObject *dict,GtkType type,gint *nargs){
    PyObject *key, *item;
    gint i = 0, pos;
    GtkArg *arg;
    GtkArgInfo *info;
    gchar *err, buf[128];

    *nargs = PyDict_Size(dict);
    arg = g_new(GtkArg, *nargs);
    pos = 0;
    while (PyDict_Next(dict, &i, &key, &item)) {
        if (!PyString_Check(key)) {
	    PyErr_SetString(PyExc_TypeError,"dictionary keys must be strings");
	    g_free(arg);
	    return NULL;
        }
	arg[pos].name = PyString_AsString(key);
	err = gtk_container_child_arg_get_info(type, arg[pos].name, &info);
	if (info == NULL) {
	    PyErr_SetString(PyExc_TypeError, err);
	    g_free(err);
	    g_free(arg);
	    return NULL;
	}
	arg[pos].type = info->type;
	arg[pos].name = info->name;
	if (GtkArg_FromPyObject(&(arg[pos]), item)) {
	    g_snprintf(buf, 255, "arg %s: expected type %s, found %s",
		       arg[pos].name, gtk_type_name(arg[pos].type),
		       item->ob_type->tp_name);
	    PyErr_SetString(PyExc_TypeError, buf);
	    g_free(arg);
	    return NULL;
	}
	pos++;
    }
    return arg;
}

static PyObject *_wrap_gtk_container_get_type(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_container_get_type")) 
        return NULL;
    return PyInt_FromLong(gtk_container_get_type());
}

static PyObject *_wrap_gtk_container_border_width(PyObject *self, PyObject *args) {
    PyObject *obj;
    int  width;

    if(!PyArg_ParseTuple(args,"O!i:gtk_container_border_width", &PyGtk_Type,
			 &obj, &width)) 
        return NULL;
    gtk_container_border_width(GTK_CONTAINER(PyGtk_Get(obj)), width);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_add(PyObject *self, PyObject *args) {
    PyObject *obj, *child, *dict = NULL;

    if(!PyArg_ParseTuple(args,"O!O!|O!:gtk_container_add", &PyGtk_Type, &obj,
			 &PyGtk_Type, &child, &PyDict_Type, &dict)) 
        return NULL;
    if (dict == NULL)
      gtk_container_add(GTK_CONTAINER(PyGtk_Get(obj)),
			GTK_WIDGET(PyGtk_Get(child)));
    else {
      gint nargs;
      GtkArg *arg = PyDict_AsContainerArgs(dict,
					   GTK_OBJECT_TYPE(PyGtk_Get(obj)),
					   &nargs);
      if (arg == NULL && nargs != 0)
	return NULL;
      gtk_container_addv(GTK_CONTAINER(PyGtk_Get(obj)),
			 GTK_WIDGET(PyGtk_Get(child)), nargs, arg);
      g_free(arg);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_child_set(PyObject *self, PyObject *args){
    PyObject *obj, *child, *dict;
    gint nargs;
    GtkArg *arg;

    if (!PyArg_ParseTuple(args, "O!O!O!:gtk_container_child_set", &PyGtk_Type,
			  &obj, &PyGtk_Type, &child, &PyDict_Type, &dict))
        return NULL;
    arg = PyDict_AsContainerArgs(dict, GTK_OBJECT_TYPE(PyGtk_Get(obj)),&nargs);
    if (arg == NULL && nargs != 0)
        return NULL;
    gtk_container_child_setv(GTK_CONTAINER(PyGtk_Get(obj)),
			     GTK_WIDGET(PyGtk_Get(child)), nargs, arg);
    g_free(arg);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_child_get(PyObject *self, PyObject *args){
    PyObject *obj, *child, *ret;
    GtkArg arg;

    if (!PyArg_ParseTuple(args, "O!O!s:gtk_container_child_get", &PyGtk_Type,
			  &obj, &PyGtk_Type, &child, &(arg.name)))
        return NULL;
    gtk_container_child_getv(GTK_CONTAINER(PyGtk_Get(obj)),
			     GTK_WIDGET(PyGtk_Get(child)), 1, &arg);
    if (arg.type == GTK_TYPE_INVALID) {
        PyErr_SetString(PyExc_AttributeError, "invalid property");
	return NULL;
    }
    ret = GtkArg_AsPyObject(&arg);
    if (ret == NULL) {
        PyErr_SetString(PyExc_TypeError, "couldn't translate type");
	return NULL;
    }
    return ret;
}

static PyObject *_wrap_gtk_container_remove(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *child;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_container_remove", &PyGtk_Type, &obj,
			 &PyGtk_Type, &child)) 
        return NULL;
    gtk_container_remove(GTK_CONTAINER(PyGtk_Get(obj)),
			 GTK_WIDGET(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_set_resize_mode(PyObject *self, PyObject *args) {
    PyObject *obj;
    GtkResizeMode mode;
    PyObject *py_mode;

    if(!PyArg_ParseTuple(args,"O!O:gtk_container_set_resize_mode",
			 &PyGtk_Type, &obj, &py_mode)) 
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_RESIZE_MODE, py_mode, (gint *)&mode))
        return NULL;
    gtk_container_set_resize_mode(GTK_CONTAINER(PyGtk_Get(obj)), mode);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_check_resize(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_check_resize", &PyGtk_Type,
			 &obj)) 
        return NULL;
    gtk_container_check_resize(GTK_CONTAINER(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_focus(PyObject *self, PyObject *args) {
    PyObject *obj;
    GtkDirectionType dir;
    PyObject *py_dir;

    if(!PyArg_ParseTuple(args,"O!O:gtk_container_focus", &PyGtk_Type, &obj,
			 &py_dir)) 
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_DIRECTION_TYPE, py_dir, (gint *)&dir))
        return NULL;
    return PyInt_FromLong(gtk_container_focus(GTK_CONTAINER(PyGtk_Get(obj)),
					      dir));
}

static PyObject *_wrap_gtk_container_set_focus_child(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *child;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_container_set_focus_child",
			 &PyGtk_Type, &obj, &PyGtk_Type, &child)) 
        return NULL;
    gtk_container_set_focus_child(GTK_CONTAINER(PyGtk_Get(obj)),
				  GTK_WIDGET(PyGtk_Get(child)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_set_focus_vadjustment(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *adj;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_container_set_focus_vadjustment",
			 &PyGtk_Type, &obj, &PyGtk_Type, &adj)) 
        return NULL;
    gtk_container_set_focus_vadjustment(GTK_CONTAINER(PyGtk_Get(obj)),
					GTK_ADJUSTMENT(PyGtk_Get(adj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_set_focus_hadjustment(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *adj;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_container_set_focus_hadjustment",
			 &PyGtk_Type, &obj, &PyGtk_Type, &adj)) 
        return NULL;
    gtk_container_set_focus_hadjustment(GTK_CONTAINER(PyGtk_Get(obj)),
					GTK_ADJUSTMENT(PyGtk_Get(adj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_children(PyObject *self, PyObject *args) {
    PyObject *obj;
    GList *list, *tmp;
    PyObject *py_list;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_children", &PyGtk_Type, &obj))
        return NULL;
    list = gtk_container_children(GTK_CONTAINER(PyGtk_Get(obj)));
    py_list = PyList_New(0);
    for (tmp = list; tmp != NULL; tmp = tmp->next)
      PyList_Append(py_list, PyGtk_New(GTK_OBJECT(tmp->data)));
    g_list_free(list);
    return py_list;
}

static PyObject *_wrap_gtk_container_register_toplevel(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_register_toplevel",
			 &PyGtk_Type, &obj)) 
        return NULL;
    gtk_container_register_toplevel(GTK_CONTAINER(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_unregister_toplevel(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_unregister_toplevel",
			 &PyGtk_Type, &obj)) 
        return NULL;
    gtk_container_unregister_toplevel(GTK_CONTAINER(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_resize_children(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_resize_children",
			 &PyGtk_Type, &obj)) 
        return NULL;
    gtk_container_resize_children(GTK_CONTAINER(PyGtk_Get(obj)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_container_child_type(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_container_child_type", &PyGtk_Type,
			 &obj)) 
        return NULL;
    return PyInt_FromLong(
            gtk_container_child_type(GTK_CONTAINER(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_window_get_type(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_window_get_type")) 
        return NULL;
    return PyInt_FromLong(gtk_window_get_type());
}

static PyObject *_wrap_gtk_window_new(PyObject *self, PyObject *args) {
    GtkWindowType tp;
    PyObject *py_tp;

    if(!PyArg_ParseTuple(args,"O:gtk_window_new", &py_tp)) 
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_WINDOW_TYPE, py_tp, (gint *)&tp))
        return NULL;
    return PyGtk_New((GtkObject *)gtk_window_new(tp));
}

static PyObject *_wrap_gtk_window_set_title(PyObject *self, PyObject *args) {
    PyObject *obj;
    char *title;

    if(!PyArg_ParseTuple(args,"O!s:gtk_window_set_title", &PyGtk_Type, &obj,
			 &title)) 
        return NULL;
    gtk_window_set_title(GTK_WINDOW(PyGtk_Get(obj)), title);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_set_wmclass(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    if(!PyArg_ParseTuple(args,"Oss:gtk_window_set_wmclass",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_wmclass(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_focus(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *focus;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_window_set_focus", &PyGtk_Type, &obj,
			 &PyGtk_Type, &focus)) 
        return NULL;
    gtk_window_set_focus(GTK_WINDOW(PyGtk_Get(obj)),
			 GTK_WIDGET(PyGtk_Get(focus)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_set_default(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *deflt;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_window_set_default", &PyGtk_Type, &obj,
			 &PyGtk_Type, &deflt)) 
        return NULL;
    gtk_window_set_default(GTK_WINDOW(PyGtk_Get(obj)),
			   GTK_WIDGET(PyGtk_Get(deflt)));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_set_policy(PyObject *self, PyObject *args) {
    PyObject *obj;
    int  shrink;
    int  grow;
    int  auto_s;

    if(!PyArg_ParseTuple(args,"O!iii:gtk_window_set_policy", &PyGtk_Type, &obj,
			 &shrink, &grow, &auto_s)) 
        return NULL;
    gtk_window_set_policy(GTK_WINDOW(PyGtk_Get(obj)), shrink, grow, auto_s);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_add_accel_group(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *accel;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_window_add_accel_group", &PyGtk_Type,
			 &obj, &PyGtkAccelGroup_Type, &accel)) 
        return NULL;
    gtk_window_add_accel_group(GTK_WINDOW(PyGtk_Get(obj)),
			       PyGtkAccelGroup_Get(accel));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_remove_accel_group(PyObject *self, PyObject *args) {
    PyObject *obj;
    PyObject *accel;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_window_remove_accel_group",
			 &PyGtk_Type, &obj, &PyGtkAccelGroup_Type, &accel)) 
        return NULL;
    gtk_window_remove_accel_group(GTK_WINDOW(PyGtk_Get(obj)),
				  PyGtkAccelGroup_Get(accel));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_position(PyObject *self, PyObject *args) {
    PyObject *obj;
    GtkWindowPosition pos;
    PyObject *py_pos;

    if(!PyArg_ParseTuple(args,"O!O:gtk_window_position", &PyGtk_Type, &obj,
			 &py_pos)) 
        return NULL;
    if (PyGtkEnum_get_value(GTK_TYPE_WINDOW_POSITION, py_pos, (gint *)&pos))
        return NULL;
    gtk_window_position(GTK_WINDOW(PyGtk_Get(obj)), pos);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_window_activate_focus(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!:gtk_window_activate_focus", &PyGtk_Type,
			 &obj)) 
        return NULL;
    return PyInt_FromLong(
            gtk_window_activate_focus(GTK_WINDOW(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_window_activate_default(PyObject *self, PyObject *args) {
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"!O:gtk_window_activate_default", &PyGtk_Type,
			 &obj)) 
        return NULL;
    return PyInt_FromLong(
            gtk_window_activate_default(GTK_WINDOW(PyGtk_Get(obj))));
}

static PyObject *_wrap_gtk_window_set_icon(PyObject *self, PyObject *args) {
	PyGtk_Object *o, *pix, *mask;
        GtkWidget *win;
	if (!PyArg_ParseTuple(args, "O!O!O!:gtk_window_set_icon", &PyGtk_Type,
			&o, &PyGdkWindow_Type, &pix, &PyGdkWindow_Type, &mask))
		return NULL;
	win = GTK_WIDGET(PyGtk_Get(o));
	gtk_widget_realize(win);
	gdk_window_set_icon(win->window, NULL, PyGdkWindow_Get(pix),
			    PyGdkWindow_Get(mask));
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *_wrap_gtk_window_set_icon_name(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *name;
	if (!PyArg_ParseTuple(args, "O!s:gtk_window_set_icon_name",
			&PyGtk_Type, &o, &name))
		return NULL;
	gdk_window_set_icon_name(GTK_WIDGET(PyGtk_Get(o))->window, name);
	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *_wrap_gtk_accel_group_new(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_accel_group_new")) 
        return NULL;
    return PyGtkAccelGroup_New(gtk_accel_group_new());
}

static PyObject *_wrap_gtk_accel_group_get_default(PyObject *self, PyObject *args) {
    if(!PyArg_ParseTuple(args,":gtk_accel_group_get_default")) 
        return NULL;
    return PyGtkAccelGroup_New(gtk_accel_group_get_default());
}

static PyObject *_wrap_gtk_accel_group_activate(PyObject *self, PyObject *args) {
    PyObject *accel;
    int key;
    GdkModifierType mod;
    PyObject *py_mod;

    if(!PyArg_ParseTuple(args,"O!iO:gtk_accel_group_activate",
			 &PyGtkAccelGroup_Type, &accel, &key, &py_mod)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    return PyInt_FromLong(gtk_accel_group_activate(PyGtkAccelGroup_Get(accel),
						   key, mod));;
}

static PyObject *_wrap_gtk_accel_groups_activate(PyObject *self, PyObject *args) {
    PyObject *obj;
    int key;
    GdkModifierType mod;
    PyObject *py_mod;

    if(!PyArg_ParseTuple(args,"O!iO:gtk_accel_groups_activate",
			 &PyGtk_Type, &obj, &key, &py_mod)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    return PyInt_FromLong(gtk_accel_groups_activate(PyGtk_Get(obj), key,
						    mod));
}

static PyObject *_wrap_gtk_accel_group_attach(PyObject *self, PyObject *args) {
    PyObject *accel;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_accel_group_attach",
			 &PyGtkAccelGroup_Type, &accel, &PyGtk_Type, &obj)) 
        return NULL;
    gtk_accel_group_attach(PyGtkAccelGroup_Get(accel), PyGtk_Get(obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_detach(PyObject *self, PyObject *args) {
    PyObject *accel;
    PyObject *obj;

    if(!PyArg_ParseTuple(args,"O!O!:gtk_accel_group_detach",
			 &PyGtkAccelGroup_Type, &accel, &PyGtk_Type, &obj)) 
        return NULL;
    gtk_accel_group_detach(PyGtkAccelGroup_Get(accel), PyGtk_Get(obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_lock(PyObject *self, PyObject *args) {
    PyObject *accel;

    if(!PyArg_ParseTuple(args,"O!:gtk_accel_group_lock",
			 &PyGtkAccelGroup_Type, &accel)) 
        return NULL;
    gtk_accel_group_lock(PyGtkAccelGroup_Get(accel));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_unlock(PyObject *self, PyObject *args) {
    PyObject *accel;

    if(!PyArg_ParseTuple(args,"O!:gtk_accel_group_unlock",
			 &PyGtkAccelGroup_Type, &accel)) 
        return NULL;
    gtk_accel_group_unlock(PyGtkAccelGroup_Get(accel));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_lock_entry(PyObject *self, PyObject *args) {
    PyObject *accel;
    int key;
    GdkModifierType mod;
    PyObject *py_mod;

    if(!PyArg_ParseTuple(args,"O!iO:gtk_accel_group_lock_entry",
			 &PyGtkAccelGroup_Type, &accel, &key, &py_mod)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    gtk_accel_group_lock_entry(PyGtkAccelGroup_Get(accel), key, mod);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_unlock_entry(PyObject *self, PyObject *args) {
    PyObject *accel;
    int key;
    GdkModifierType mod;
    PyObject *py_mod;

    if(!PyArg_ParseTuple(args,"O!iO:gtk_accel_group_unlock_entry",
			 &PyGtkAccelGroup_Type, &accel, &key, &py_mod)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    gtk_accel_group_unlock_entry(PyGtkAccelGroup_Get(accel), key, mod);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_add(PyObject *self, PyObject *args) {
    PyObject *accel;
    int key;
    GdkModifierType mod;
    GtkAccelFlags flags;
    PyObject *obj;
    char *signal;
    PyObject *py_mod;
    PyObject *py_flags;

    if(!PyArg_ParseTuple(args,"O!iOOO!s:gtk_accel_group_add",
			 &PyGtkAccelGroup_Type, &accel, &key, &py_mod,
			 &py_flags, &PyGtk_Type, &obj, &signal)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_ACCEL_FLAGS, py_flags, (gint *)&flags))
        return NULL;
    gtk_accel_group_add(PyGtkAccelGroup_Get(accel), key, mod, flags,
			PyGtk_Get(obj), signal);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *_wrap_gtk_accel_group_remove(PyObject *self, PyObject *args) {
    PyObject *accel;
    int key;
    GdkModifierType mod;
    PyObject *obj;
    PyObject *py_mod;

    if(!PyArg_ParseTuple(args,"O!iOO!:gtk_accel_group_remove",
			 &PyGtkAccelGroup_Type, &accel, &key, &py_mod,
			 &PyGtk_Type, &obj)) 
        return NULL;
    if (PyGtkFlag_get_value(GTK_TYPE_GDK_MODIFIER_TYPE, py_mod, (gint *)&mod))
        return NULL;
    gtk_accel_group_remove(PyGtkAccelGroup_Get(accel), key, mod,
			   PyGtk_Get(obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _gtkbaseMethods[] = {
	 { "gtk_accel_group_remove", _wrap_gtk_accel_group_remove, 1 },
	 { "gtk_accel_group_add", _wrap_gtk_accel_group_add, 1 },
	 { "gtk_accel_group_unlock_entry", _wrap_gtk_accel_group_unlock_entry, 1 },
	 { "gtk_accel_group_lock_entry", _wrap_gtk_accel_group_lock_entry, 1 },
	 { "gtk_accel_group_unlock", _wrap_gtk_accel_group_unlock, 1 },
	 { "gtk_accel_group_lock", _wrap_gtk_accel_group_lock, 1 },
	 { "gtk_accel_group_detach", _wrap_gtk_accel_group_detach, 1 },
	 { "gtk_accel_group_attach", _wrap_gtk_accel_group_attach, 1 },
	 { "gtk_accel_groups_activate", _wrap_gtk_accel_groups_activate, 1 },
	 { "gtk_accel_group_activate", _wrap_gtk_accel_group_activate, 1 },
	 { "gtk_accel_group_get_default", _wrap_gtk_accel_group_get_default, 1 },
	 { "gtk_accel_group_new", _wrap_gtk_accel_group_new, 1 },
	 { "gtk_window_set_icon_name", _wrap_gtk_window_set_icon_name, 1 },
	 { "gtk_window_set_icon", _wrap_gtk_window_set_icon, 1 },
	 { "gtk_window_activate_default", _wrap_gtk_window_activate_default, 1 },
	 { "gtk_window_activate_focus", _wrap_gtk_window_activate_focus, 1 },
	 { "gtk_window_position", _wrap_gtk_window_position, 1 },
	 { "gtk_window_remove_accel_group", _wrap_gtk_window_remove_accel_group, 1 },
	 { "gtk_window_add_accel_group", _wrap_gtk_window_add_accel_group, 1 },
	 { "gtk_window_set_policy", _wrap_gtk_window_set_policy, 1 },
	 { "gtk_window_set_default", _wrap_gtk_window_set_default, 1 },
	 { "gtk_window_set_focus", _wrap_gtk_window_set_focus, 1 },
	 { "gtk_window_set_wmclass", _wrap_gtk_window_set_wmclass, 1 },
	 { "gtk_window_set_title", _wrap_gtk_window_set_title, 1 },
	 { "gtk_window_new", _wrap_gtk_window_new, 1 },
	 { "gtk_window_get_type", _wrap_gtk_window_get_type, 1 },
	 { "gtk_container_child_type", _wrap_gtk_container_child_type, 1 },
	 { "gtk_container_resize_children", _wrap_gtk_container_resize_children, 1 },
	 { "gtk_container_unregister_toplevel", _wrap_gtk_container_unregister_toplevel, 1 },
	 { "gtk_container_register_toplevel", _wrap_gtk_container_register_toplevel, 1 },
	 { "gtk_container_children", _wrap_gtk_container_children, 1 },
	 { "gtk_container_set_focus_hadjustment", _wrap_gtk_container_set_focus_hadjustment, 1 },
	 { "gtk_container_set_focus_vadjustment", _wrap_gtk_container_set_focus_vadjustment, 1 },
	 { "gtk_container_set_focus_child", _wrap_gtk_container_set_focus_child, 1 },
	 { "gtk_container_focus", _wrap_gtk_container_focus, 1 },
	 { "gtk_container_check_resize", _wrap_gtk_container_check_resize, 1 },
	 { "gtk_container_set_resize_mode", _wrap_gtk_container_set_resize_mode, 1 },
	 { "gtk_container_remove", _wrap_gtk_container_remove, 1 },
	 { "gtk_container_child_get", _wrap_gtk_container_child_get, 1 },
	 { "gtk_container_child_set", _wrap_gtk_container_child_set, 1 },
	 { "gtk_container_add", _wrap_gtk_container_add, 1 },
	 { "gtk_container_border_width", _wrap_gtk_container_border_width, 1 },
	 { "gtk_container_get_type", _wrap_gtk_container_get_type, 1 },
	 { "gtk_widget_dnd_data_set", _wrap_gtk_widget_dnd_data_set, 1 },
	 { "gtk_widget_dnd_drop_set", _wrap_gtk_widget_dnd_drop_set, 1 },
	 { "gtk_widget_dnd_drag_set", _wrap_gtk_widget_dnd_drag_set, 1 },
	 { "gtk_widget_dnd_drag_add", _wrap_gtk_widget_dnd_drag_add, 1 },
	 { "gtk_widget_shape_combine_mask", _wrap_gtk_widget_shape_combine_mask, 1 },
	 { "gtk_widget_set_default_style", _wrap_gtk_widget_set_default_style, 1 },
	 { "gtk_widget_pop_style", _wrap_gtk_widget_pop_style, 1 },
	 { "gtk_widget_push_style", _wrap_gtk_widget_push_style, 1 },
	 { "gtk_widget_hide_on_delete", _wrap_gtk_widget_hide_on_delete, 1 },
	 { "gtk_widget_is_child", _wrap_gtk_widget_is_child, 1 },
	 { "gtk_widget_is_ancestor", _wrap_gtk_widget_is_ancestor, 1 },
	 { "gtk_widget_get_pointer", gtk_widget__get_pointer, 1 },
	 { "gtk_widget_get_extension_events", _wrap_gtk_widget_get_extension_events, 1 },
	 { "gtk_widget_get_events", _wrap_gtk_widget_get_events, 1 },
	 { "gtk_widget_get_style", _wrap_gtk_widget_get_style, 1 },
	 { "gtk_widget_get_ancestor", _wrap_gtk_widget_get_ancestor, 1 },
	 { "gtk_widget_get_toplevel", _wrap_gtk_widget_get_toplevel, 1 },
	 { "gtk_widget_set_extension_events", _wrap_gtk_widget_set_extension_events, 1 },
	 { "gtk_widget_set_events", _wrap_gtk_widget_set_events, 1 },
	 { "gtk_widget_set_usize", _wrap_gtk_widget_set_usize, 1 },
	 { "gtk_widget_set_uposition", _wrap_gtk_widget_set_uposition, 1 },
	 { "gtk_widget_reset_rc_styles", _wrap_gtk_widget_reset_rc_styles, 1 },
	 { "gtk_widget_restore_default_style", _wrap_gtk_widget_restore_default_style, 1 },
	 { "gtk_widget_ensure_style", _wrap_gtk_widget_ensure_style, 1 },
	 { "gtk_widget_set_rc_style", _wrap_gtk_widget_set_rc_style, 1 },
	 { "gtk_widget_set_style", _wrap_gtk_widget_set_style, 1 },
	 { "gtk_widget_get_parent_window", _wrap_gtk_widget_get_parent_window, 1 },
	 { "gtk_widget_set_parent_window", _wrap_gtk_widget_set_parent_window, 1 },
	 { "gtk_widget_set_parent", _wrap_gtk_widget_set_parent, 1 },
	 { "gtk_widget_set_sensitive", _wrap_gtk_widget_set_sensitive, 1 },
	 { "gtk_widget_set_state", _wrap_gtk_widget_set_state, 1 },
	 { "gtk_widget_get_name", _wrap_gtk_widget_get_name, 1 },
	 { "gtk_widget_set_name", _wrap_gtk_widget_set_name, 1 },
	 { "gtk_widget_grab_default", _wrap_gtk_widget_grab_default, 1 },
	 { "gtk_widget_grab_focus", _wrap_gtk_widget_grab_focus, 1 },
	 { "gtk_widget_basic", _wrap_gtk_widget_basic, 1 },
	 { "gtk_widget_intersect", _wrap_gtk_widget_intersect, 1 },
	 { "gtk_widget_popup", _wrap_gtk_widget_popup, 1 },
	 { "gtk_widget_reparent", _wrap_gtk_widget_reparent, 1 },
	 { "gtk_widget_activate", _wrap_gtk_widget_activate, 1 },
	 { "gtk_widget_event", _wrap_gtk_widget_event, 1 },
	 { "gtk_widget_thaw_accelerators", _wrap_gtk_widget_thaw_accelerators, 1 },
	 { "gtk_widget_freeze_accelerators", _wrap_gtk_widget_freeze_accelerators, 1 },
	 { "gtk_widget_remove_accelerators", _wrap_gtk_widget_remove_accelerators, 1 },
	 { "gtk_widget_remove_accelerator", _wrap_gtk_widget_remove_accelerator, 1 },
	 { "gtk_widget_add_accelerator", _wrap_gtk_widget_add_accelerator, 1 },
	 { "gtk_widget_size_allocate", _wrap_gtk_widget_size_allocate, 1 },
	 { "gtk_widget_size_request", _wrap_gtk_widget_size_request, 1 },
	 { "gtk_widget_draw_children", _wrap_gtk_widget_draw_children, 1 },
	 { "gtk_widget_draw_default", _wrap_gtk_widget_draw_default, 1 },
	 { "gtk_widget_draw_focus", _wrap_gtk_widget_draw_focus, 1 },
	 { "gtk_widget_draw", _wrap_gtk_widget_draw, 1 },
	 { "gtk_widget_queue_resize", _wrap_gtk_widget_queue_resize, 1 },
	 { "gtk_widget_queue_draw", _wrap_gtk_widget_queue_draw, 1 },
	 { "gtk_widget_unrealize", _wrap_gtk_widget_unrealize, 1 },
	 { "gtk_widget_realize", _wrap_gtk_widget_realize, 1 },
	 { "gtk_widget_unmap", _wrap_gtk_widget_unmap, 1 },
	 { "gtk_widget_map", _wrap_gtk_widget_map, 1 },
	 { "gtk_widget_hide_all", _wrap_gtk_widget_hide_all, 1 },
	 { "gtk_widget_show_now", _wrap_gtk_widget_show_now, 1 },
	 { "gtk_widget_show_all", _wrap_gtk_widget_show_all, 1 },
	 { "gtk_widget_hide", _wrap_gtk_widget_hide, 1 },
	 { "gtk_widget_show", _wrap_gtk_widget_show, 1 },
	 { "gtk_widget_unparent", _wrap_gtk_widget_unparent, 1 },
	 { "gtk_widget_destroy", _wrap_gtk_widget_destroy, 1 },
	 { "gtk_widget_get_window", _wrap_gtk_widget_get_window, 1 },
	 { "gtk_widget_get_type", _wrap_gtk_widget_get_type, 1 },
	 { "gtk_object_remove_data", _wrap_gtk_object_remove_data, 1 },
	 { "gtk_object_get_data", _wrap_gtk_object_get_data, 1 },
	 { "gtk_object_set_data", _wrap_gtk_object_set_data, 1 },
	 { "GTK_OBJECT_UNSET_FLAGS", _wrap_GTK_OBJECT_UNSET_FLAGS, 1 },
	 { "GTK_OBJECT_SET_FLAGS", _wrap_GTK_OBJECT_SET_FLAGS, 1 },
	 { "GTK_OBJECT_TYPE", _wrap_GTK_OBJECT_TYPE, 1 },
	 { "GTK_OBJECT_FLAGS", _wrap_GTK_OBJECT_FLAGS, 1 },
	 { "gtk_object_get_type", _wrap_gtk_object_get_type, 1 },
	 { "GTK_CHECK_TYPE", _wrap_GTK_CHECK_TYPE, 1 },
	 { "gtk_type_from_name", _wrap_gtk_type_from_name, 1 },
	 { "gtk_type_name", _wrap_gtk_type_name, 1 },
	 { "gtk_object_get", _wrap_gtk_object_get, 1 },
	 { "gtk_object_new", _wrap_gtk_object_new, 1 },
	 { "gtk_object_set", _wrap_gtk_object_set, 1 },
	 { "gtk_rc_add_widget_class_style", _wrap_gtk_rc_add_widget_class_style, 1 },
	 { "gtk_rc_add_widget_name_style", _wrap_gtk_rc_add_widget_name_style, 1 },
	 { "gtk_rc_get_style", _wrap_gtk_rc_get_style, 1 },
	 { "gtk_rc_parse_string", _wrap_gtk_rc_parse_string, 1 },
	 { "gtk_rc_parse", _wrap_gtk_rc_parse, 1 },
	 { "gtk_rc_init", _wrap_gtk_rc_init, 1 },
	 { "gtk_input_remove", _wrap_gtk_input_remove, 1 },
	 { "gtk_input_add", _wrap_gtk_input_add, 1 },
	 { "gtk_quit_add_destroy", _wrap_gtk_quit_add_destroy, 1 },
	 { "gtk_quit_remove_function", _wrap_gtk_quit_remove_function, 1 },
	 { "gtk_quit_remove", _wrap_gtk_quit_remove, 1 },
	 { "gtk_quit_add", _wrap_gtk_quit_add, 1 },
	 { "gtk_idle_remove_function", _wrap_gtk_idle_remove_function, 1 },
	 { "gtk_idle_remove", _wrap_gtk_idle_remove, 1 },
	 { "gtk_idle_add_priority", _wrap_gtk_idle_add_priority, 1 },
	 { "gtk_idle_add", _wrap_gtk_idle_add, 1 },
	 { "gtk_timeout_remove", _wrap_gtk_timeout_remove, 1 },
	 { "gtk_timeout_add", _wrap_gtk_timeout_add, 1 },
	 { "gtk_set_locale", _wrap_gtk_set_locale, 1 },
	 { "gtk_grab_remove", _wrap_gtk_grab_remove, 1 },
	 { "gtk_grab_add", _wrap_gtk_grab_add, 1 },
	 { "gtk_main_iteration", _wrap_gtk_main_iteration, 1 },
	 { "gtk_main_quit", _wrap_gtk_main_quit, 1 },
	 { "gtk_main", _wrap_gtk_main, 1 },
	 { "gtk_exit", _wrap_gtk_exit, 1 },
	 { "gtk_init", _wrap_gtk_init, 1 },
	 { "gtk_signal_emitv_by_name", _wrap_gtk_signal_emitv_by_name, 1 },
	 { "gtk_signal_emit_stop_by_name", _wrap_gtk_signal_emit_stop_by_name, 1 },
	 { "gtk_signal_handlers_destroy", _wrap_gtk_signal_handlers_destroy, 1 },
	 { "gtk_signal_handler_unblock_by_data", _wrap_gtk_signal_handler_unblock_by_data, 1 },
	 { "gtk_signal_handler_unblock", _wrap_gtk_signal_handler_unblock, 1 },
	 { "gtk_signal_handler_block_by_data", _wrap_gtk_signal_handler_block_by_data, 1 },
	 { "gtk_signal_handler_block", _wrap_gtk_signal_handler_block, 1 },
	 { "gtk_signal_disconnect_by_data", _wrap_gtk_signal_disconnect_by_data, 1 },
	 { "gtk_signal_disconnect", _wrap_gtk_signal_disconnect, 1 },
	 { "gtk_signal_connect_after", _wrap_gtk_signal_connect_after, 1 },
	 { "gtk_signal_connect", _wrap_gtk_signal_connect, 1 },
	 { NULL, NULL }
};

void init_gtkbase() {
     PyObject *m, *d, *private;
     m = Py_InitModule("_gtkbase", _gtkbaseMethods);
     d = PyModule_GetDict(m);

     PyDict_SetItemString(d, "GtkObjectType", (PyObject *)&PyGtk_Type);
     PyDict_SetItemString(d, "GtkAccelGroupType",
			  (PyObject *)&PyGtkAccelGroup_Type);
     PyDict_SetItemString(d, "GtkStyleType", (PyObject *)&PyGtkStyle_Type);
     PyDict_SetItemString(d, "GdkFontType", (PyObject *)&PyGdkFont_Type);
     PyDict_SetItemString(d, "GdkColorType", (PyObject *)&PyGdkColor_Type);
     PyDict_SetItemString(d, "GdkEventType", (PyObject *)&PyGdkEvent_Type);
     PyDict_SetItemString(d, "GdkWindowType", (PyObject *)&PyGdkWindow_Type);
     PyDict_SetItemString(d, "GdkGCType", (PyObject *)&PyGdkGC_Type);
     PyDict_SetItemString(d, "GdkColormapType",(PyObject*)&PyGdkColormap_Type);

     private = PyDict_New();
     PyDict_SetItemString(d, "_private", private); Py_DECREF(private);
     PyDict_SetItemString(private, "PyGtk_New", 
			  d=PyCObject_FromVoidPtr(PyGtk_New, NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtkAccelGroup_New",
			  d=PyCObject_FromVoidPtr(PyGtkAccelGroup_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtkStyle_New",
			  d=PyCObject_FromVoidPtr(PyGtkStyle_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkFont_New",
			  d=PyCObject_FromVoidPtr(PyGdkFont_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkColor_New",
			  d=PyCObject_FromVoidPtr(PyGdkColor_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkEvent_New",
			  d=PyCObject_FromVoidPtr(PyGdkEvent_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkWindow_New",
			  d=PyCObject_FromVoidPtr(PyGdkWindow_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkGC_New",
			  d=PyCObject_FromVoidPtr(PyGdkGC_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGdkColormap_New",
			  d=PyCObject_FromVoidPtr(PyGdkColormap_New,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtk_DestroyNotify",
			  d=PyCObject_FromVoidPtr(PyGtk_DestroyNotify,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtk_CallbackMarshal",
			  d=PyCObject_FromVoidPtr(PyGtk_CallbackMarshal,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkArgs_AsTuple",
			  d=PyCObject_FromVoidPtr(GtkArgs_AsTuple,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkArgs_FromSequence",
			  d=PyCObject_FromVoidPtr(GtkArgs_FromSequence,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkArg_FromPyObject",
			  d=PyCObject_FromVoidPtr(GtkArg_FromPyObject,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkArg_AsPyObject",
			  d=PyCObject_FromVoidPtr(GtkArg_AsPyObject,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkRet_FromPyObject",
			  d=PyCObject_FromVoidPtr(GtkRet_FromPyObject,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "GtkRet_AsPyObject",
			  d=PyCObject_FromVoidPtr(GtkRet_AsPyObject,NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtkEnum_get_value",
			  d=PyCObject_FromVoidPtr(PyGtkEnum_get_value, NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyGtkFlag_get_value",
			  d=PyCObject_FromVoidPtr(PyGtkFlag_get_value, NULL));
     Py_DECREF(d);
     PyDict_SetItemString(private, "PyDict_AsGtkArgs",
			  d=PyCObject_FromVoidPtr(PyDict_AsGtkArgs, NULL));
     Py_DECREF(d);
}
