%{

typedef struct {
	PyObject_HEAD
	GtkAcceleratorTable *obj;
} PyGtkAccelerator_Object;
staticforward PyTypeObject PyGtkAccelerator_Type;

typedef struct {
	PyObject_HEAD
	GtkStyle *obj;
} PyGtkStyle_Object;
staticforward PyTypeObject PyGtkStyle_Type;

typedef struct {
	PyObject_HEAD
	GdkFont *obj;
} PyGdkFont_Object;
staticforward PyTypeObject PyGdkFont_Type;

typedef struct {
	PyObject_HEAD
	GdkColor obj;
} PyGdkColor_Object;
staticforward PyTypeObject PyGdkColor_Type;

typedef struct {
	PyObject_HEAD
	GdkEvent *obj;
	PyObject *attrs;
} PyGdkEvent_Object;
staticforward PyTypeObject PyGdkEvent_Type;

typedef struct {
        PyObject_HEAD;
        GdkWindow *obj;
        const char *type;
} PyGdkWindow_Object;
staticforward PyTypeObject PyGdkWindow_Type;

typedef struct {
        PyObject_HEAD;
        GdkGC *obj;
} PyGdkGC_Object;
staticforward PyTypeObject PyGdkGC_Type;

#define PyGtkAccelerator_Check(v) ((v)->ob_type == &PyGtkAccelerator_Type)
#define PyGtkAccelerator_Get(v) (((PyGtkAccelerator_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == &PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == &PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == &PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == &PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == &PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == &PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)


static PyObject *
PyGtkAccelerator_New(GtkAcceleratorTable *obj) {
  PyGtkAccelerator_Object  *self;

  self = (PyGtkAccelerator_Object *)PyObject_NEW(PyGtkAccelerator_Object ,
              &PyGtkAccelerator_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_accelerator_table_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGtkStyle_New(GtkStyle *obj) {
  PyGtkStyle_Object *self;

  self = (PyGtkStyle_Object *)PyObject_NEW(PyGtkStyle_Object,
                                           &PyGtkStyle_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_style_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkFont_New(GdkFont *obj) {
  PyGdkFont_Object *self;

  self = (PyGdkFont_Object *)PyObject_NEW(PyGdkFont_Object, &PyGdkFont_Type);
  /*gdk_font_ref(obj);*/
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static PyObject *
PyGdkColor_New(GdkColor *obj) {
  PyGdkColor_Object *self;

  self = (PyGdkColor_Object *)PyObject_NEW(PyGdkColor_Object,&PyGdkColor_Type);
  if (self == NULL)
    return NULL;
  self->obj.pixel = obj->pixel;
  self->obj.red   = obj->red;
  self->obj.green = obj->green;
  self->obj.blue  = obj->blue;
  return (PyObject *)self;
}

static PyObject *
PyGdkWindow_New(GdkWindow *win, const char *type) {
  PyGdkWindow_Object *self;

  self = (PyGdkWindow_Object *)PyObject_NEW(PyGdkWindow_Object,
					    &PyGdkWindow_Type);
  if (self == NULL)
    return NULL;
  self->obj = win;
  if (type)
    self->type = type;
  else
    self->type = "GdkWindow";
  gdk_window_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkGC_New(GdkGC *gc) {
  PyGdkGC_Object *self;

  self = (PyGdkGC_Object *)PyObject_NEW(PyGdkGC_Object, &PyGdkGC_Type);
  if (self == NULL)
    return NULL;
  self->obj = gc;
  gdk_gc_ref(self->obj);
  return (PyObject *)self;
}

static void
PyGtkAccelerator_Dealloc(PyGtkAccelerator_Object *self) {
  gtk_accelerator_table_unref(self->obj); 
  PyMem_DEL(self);
}

static int
PyGtkAccelerator_Compare(PyGtkAccelerator_Object *self,
                            PyGtkAccelerator_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGtkAccelerator_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkAcceleratorTable",
  sizeof(PyGtkAccelerator_Object),
  0,
  (destructor)PyGtkAccelerator_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGtkAccelerator_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGtkStyle_Dealloc(PyGtkStyle_Object *self) {
  gtk_style_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtkStyle_Compare(PyGtkStyle_Object *self, PyGtkStyle_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *PyGtkStyle_GetAttr(PyGtkStyle_Object *self, char *attr) {
  GtkStyle *style = self->obj;
  PyObject *ret;
  int i;

  if (!strcmp(attr, "__members__"))
    return Py_BuildValue("[ssssssssssssssssssss]", "base", "base_gc", "bg",
			 "bg_gc", "bg_pixmap", "black", "black_gc", "dark",
			 "dark_gc", "fg", "fg_gc", "font", "light",
			 "light_gc", "mid", "mid_gc", "text", "text_gc",
			 "white", "white_gc");
  if (!strcmp(attr, "fg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->fg[i]));
    return ret;
  }
  if (!strcmp(attr, "bg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->bg[i]));
    return ret;
  }
  if (!strcmp(attr, "light")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->light[i]));
    return ret;
  }
  if (!strcmp(attr, "dark")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->dark[i]));
    return ret;
  }
  if (!strcmp(attr, "mid")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->mid[i]));
    return ret;
  }
  if (!strcmp(attr, "text")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->text[i]));
    return ret;
  }
  if (!strcmp(attr, "base")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->base[i]));
    return ret;
  }
  if (!strcmp(attr, "black"))
    return PyGdkColor_New(&style->black);
  if (!strcmp(attr, "white"))
    return PyGdkColor_New(&style->white);
  if (!strcmp(attr, "font")) {
    gdk_font_ref(style->font);
    return PyGdkFont_New(style->font);
  }
  if (!strcmp(attr, "fg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->fg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "bg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->bg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "light_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->light_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "dark_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->dark_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "mid_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->mid_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "text_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->text_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "base_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->base_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "black_gc"))
    return PyGdkGC_New(style->black_gc);
  if (!strcmp(attr, "white_gc"))
    return PyGdkGC_New(style->white_gc);
  if (!strcmp(attr, "bg_pixmap")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i,PyGdkWindow_New(style->bg_pixmap[i],"GdkPixmap"));
    return ret;
  }

  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static PyTypeObject PyGtkStyle_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkStyle",
  sizeof(PyGtkStyle_Object),
  0,
  (destructor)PyGtkStyle_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGtkStyle_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGtkStyle_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkFont_Dealloc(PyGdkFont_Object *self) {
  gdk_font_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkFont_Compare(PyGdkFont_Object *self, PyGdkFont_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkFont_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkFont",
  sizeof(PyGdkFont_Object),
  0,
  (destructor)PyGdkFont_Dealloc,
  (printfunc)0,
  (getattrfunc)0,                  
  (setattrfunc)0,
  (cmpfunc)PyGdkFont_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColor_Dealloc(PyGdkColor_Object *self) {
  PyMem_DEL(self);
}

static int
PyGdkColor_Compare(PyGdkColor_Object *self, PyGdkColor_Object *v) {
  if (self->obj.pixel == v->obj.pixel) return 0;
  if (self->obj.pixel > v->obj.pixel) return -1;
  return 1;
}

static PyTypeObject PyGdkColor_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColor",
  sizeof(PyGdkColor_Object),
  0,
  (destructor)PyGdkColor_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkColor_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static PyObject *
PyGdkEvent_New(GdkEvent *obj) {
  PyGdkEvent_Object *self;

  self = (PyGdkEvent_Object *)PyObject_NEW(PyGdkEvent_Object,&PyGdkEvent_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  self->attrs = PyDict_New();
  PyDict_SetItemString(self->attrs, "type", PyInt_FromLong(obj->type));
  PyDict_SetItemString(self->attrs, "window", PyGdkWindow_New(obj->any.window,
							      "GdkWindow"));
  PyDict_SetItemString(self->attrs, "send_event", PyInt_FromLong(
    obj->any.send_event));
  /* XXX Does anyone need the window attribute?? */
  switch(obj->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
      PyDict_SetItemString(self->attrs, "area", Py_BuildValue("(iiii)",
        obj->expose.area.x, obj->expose.area.y, obj->expose.area.width,
        obj->expose.area.height));
      PyDict_SetItemString(self->attrs, "count", PyInt_FromLong(
        obj->expose.count));
      break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->motion.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->motion.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->motion.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->motion.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->motion.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->motion.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->motion.state));
      PyDict_SetItemString(self->attrs, "is_hint", PyInt_FromLong(
        obj->motion.is_hint));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->motion.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->motion.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->motion.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->motion.y_root));
      break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->button.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->button.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->button.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->button.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->button.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->button.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->button.state));
      PyDict_SetItemString(self->attrs, "button", PyInt_FromLong(
        obj->button.button));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->button.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->button.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->button.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->button.y_root));
      break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(obj->key.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->key.state));
      PyDict_SetItemString(self->attrs, "keyval", PyInt_FromLong(
        obj->key.keyval));
      PyDict_SetItemString(self->attrs, "string", PyString_FromStringAndSize(
        obj->key.string, obj->key.length));
      break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
      /*subwindow*/
      PyDict_SetItemString(self->attrs, "detail", PyInt_FromLong(
        obj->crossing.detail));
      break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
      PyDict_SetItemString(self->attrs, "_in", PyInt_FromLong(
        obj->focus_change.in));
      break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
      PyDict_SetItemString(self->attrs, "x", PyInt_FromLong(obj->configure.x));
      PyDict_SetItemString(self->attrs, "y", PyInt_FromLong(obj->configure.y));
      PyDict_SetItemString(self->attrs, "width", PyInt_FromLong(
        obj->configure.width));
      PyDict_SetItemString(self->attrs, "height", PyInt_FromLong(
        obj->configure.height));
      break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
      PyDict_SetItemString(self->attrs, "atom", PyInt_FromLong(
        obj->property.atom));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->property.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->property.state));
      break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
      PyDict_SetItemString(self->attrs, "selection", PyInt_FromLong(
        obj->selection.selection));
      PyDict_SetItemString(self->attrs, "target", PyInt_FromLong(
        obj->selection.target));
      PyDict_SetItemString(self->attrs, "property", PyInt_FromLong(
        obj->selection.property));
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->selection.requestor));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->selection.time));
      break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->proximity.time));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->proximity.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->proximity.deviceid));
      break;
    case GDK_DRAG_BEGIN:        /*GdkEventDragBegin         dragbegin*/
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dragbegin.u.flags.protocol_version));
      break;
    case GDK_DRAG_REQUEST:      /*GdkEventDragRequest       dragrequest*/
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dragrequest.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "sendreply", PyInt_FromLong(
        obj->dragrequest.u.flags.sendreply));
      PyDict_SetItemString(self->attrs, "willaccept", PyInt_FromLong(
        obj->dragrequest.u.flags.willaccept));
      PyDict_SetItemString(self->attrs, "delete_data", PyInt_FromLong(
        obj->dragrequest.u.flags.delete_data));
      PyDict_SetItemString(self->attrs, "senddata", PyInt_FromLong(
        obj->dragrequest.u.flags.senddata));
      PyDict_SetItemString(self->attrs, "isdrop", PyInt_FromLong(
        obj->dragrequest.isdrop));
      PyDict_SetItemString(self->attrs, "drop_coords", Py_BuildValue("(ii)",
        obj->dragrequest.drop_coords.x, obj->dragrequest.drop_coords.y));
      PyDict_SetItemString(self->attrs, "data_type", PyString_FromString(
        obj->dragrequest.data_type));
      PyDict_SetItemString(self->attrs, "timestamp", PyInt_FromLong(
        obj->dragrequest.timestamp));
      break;
    case GDK_DROP_ENTER:        /*GdkEventDropEnter         dropenter*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropenter.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropenter.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "sendreply", PyInt_FromLong(
        obj->dropenter.u.flags.sendreply));
      PyDict_SetItemString(self->attrs, "extended_typelist", PyInt_FromLong(
        obj->dropenter.u.flags.extended_typelist));
      break;
    case GDK_DROP_LEAVE:        /*GdkEventDropLeave         dropleave*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropleave.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropleave.u.flags.protocol_version));
      break;
    case GDK_DROP_DATA_AVAIL:   /*GdkEventDropDataAvailable dropdataavailable*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropdataavailable.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropdataavailable.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "isdrop", PyInt_FromLong(
        obj->dropdataavailable.u.flags.isdrop));
      PyDict_SetItemString(self->attrs, "data_type", PyString_FromString(
        obj->dropdataavailable.data_type));
      PyDict_SetItemString(self->attrs, "data", PyString_FromStringAndSize(
        obj->dropdataavailable.data, obj->dropdataavailable.data_numbytes));
      PyDict_SetItemString(self->attrs, "timestamp", PyInt_FromLong(
        obj->dropdataavailable.timestamp));
      PyDict_SetItemString(self->attrs, "coords", Py_BuildValue("(ii)",
        obj->dropdataavailable.coords.x, obj->dropdataavailable.coords.y));
      break;
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
      PyDict_SetItemString(self->attrs, "message_type", PyInt_FromLong(
        obj->client.message_type));
      PyDict_SetItemString(self->attrs, "data_format", PyInt_FromLong(
        obj->client.data_format));
      PyDict_SetItemString(self->attrs, "data", PyString_FromStringAndSize(
        obj->client.data.b, 20));
      break;
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->visibility.state));
      break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
      break;
    case GDK_OTHER_EVENT:
    default:
  }
  return (PyObject *)self;
}

static void
PyGdkEvent_Dealloc(PyGdkEvent_Object *self) {
  Py_XDECREF(self->attrs);
  PyMem_DEL(self);
}

static PyObject *
PyGdkEvent_GetAttr(PyGdkEvent_Object *self, char *attr) {
  PyObject *ret;
  ret = PyDict_GetItemString(self->attrs, attr);
  if (ret != NULL) {
    Py_INCREF(ret);
    return ret;
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static int
PyGdkEvent_Compare(PyGdkEvent_Object *self, PyGdkEvent_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkEvent_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkEvent",
  sizeof(PyGdkEvent_Object),
  0,
  (destructor)PyGdkEvent_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkEvent_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkEvent_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkWindow_Dealloc(PyGdkWindow_Object *self) {
  gdk_window_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkWindow_Compare(PyGdkWindow_Object *self, PyGdkWindow_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *
PyGdkWindow_Repr(PyGdkWindow_Object *self) {
  char buf[100];
  sprintf(buf, "<%s at %lx>", self->type, (long)PyGdkWindow_Get(self));
  return PyString_FromString(buf);
}

static PyObject *
PyGdkWindow_SetAttr(PyGdkWindow_Object *self, char *key) {
  GdkWindow *win = PyGdkWindow_Get(self);
  gint x, y;
  GdkModifierType p_mask;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sssssssss]", "height", "parent", "pointer",
			 "pointer_state", "toplevel", "type", "width", "x",
			 "y");
  if (!strcmp(key, "width")) {
    gdk_window_get_size(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "height")) {
    gdk_window_get_size(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "x")) {
    gdk_window_get_position(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "y")) {
    gdk_window_get_position(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "pointer")) {
    gdk_window_get_pointer(win, &x, &y, NULL);
    return Py_BuildValue("(ii)", x, y);
  }
  if (!strcmp(key, "pointer_state")) {
    gdk_window_get_pointer(win, NULL, NULL, &p_mask);
    return PyInt_FromLong(p_mask);
  }
  if (!strcmp(key, "parent"))
    return PyGdkWindow_New(gdk_window_get_parent(win), "GdkWindow");
  if (!strcmp(key, "toplevel"))
    return PyGdkWindow_New(gdk_window_get_toplevel(win), "GdkWindow");
  if (!strcmp(key, "type"))
    return PyInt_FromLong(gdk_window_get_type(win));
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static PyTypeObject PyGdkWindow_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkWindow",
  sizeof(PyGdkWindow_Object),
  0,
  (destructor)PyGdkWindow_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkWindow_SetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkWindow_Compare,
  (reprfunc)PyGdkWindow_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkGC_Dealloc(PyGdkGC_Object *self) {
  gdk_gc_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkGC_Compare(PyGdkGC_Object *self, PyGdkGC_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkGC_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkGC",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkGC_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkGC_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};
%}


