%{

typedef struct {
	PyObject_HEAD
	GtkAcceleratorTable *obj;
} PyGtkAccelerator_Object;
staticforward PyTypeObject PyGtkAccelerator_Type;

typedef struct {
	PyObject_HEAD
	GtkStyle *obj;
} PyGtkStyle_Object;
staticforward PyTypeObject PyGtkStyle_Type;

typedef struct {
	PyObject_HEAD
	GdkFont *obj;
} PyGdkFont_Object;
staticforward PyTypeObject PyGdkFont_Type;

typedef struct {
	PyObject_HEAD
	GdkColor *obj;
} PyGdkColor_Object;
staticforward PyTypeObject PyGdkColor_Type;

typedef struct {
	PyObject_HEAD
	GdkEvent *obj;
	PyObject *attrs;
} PyGdkEvent_Object;
staticforward PyTypeObject PyGdkEvent_Type;

#define PyGtkAccelerator_Check(v) ((v)->ob_type == &PyGtkAccelerator_Type)
#define PyGtkAccelerator_Get(v) (((PyGtkAccelerator_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == &PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == &PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == &PyGdkColor_Type)
#define PyGdkColor_Get(v) (((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == &PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)


static PyObject *
PyGtkAccelerator_New(GtkAcceleratorTable *obj) {
  PyGtkAccelerator_Object  *self;

  self = (PyGtkAccelerator_Object *)PyObject_NEW(PyGtkAccelerator_Object ,
              &PyGtkAccelerator_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_accelerator_table_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGtkStyle_New(GtkStyle *obj) {
  PyGtkStyle_Object *self;

  self = (PyGtkStyle_Object *)PyObject_NEW(PyGtkStyle_Object,
                                           &PyGtkStyle_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_style_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkFont_New(GdkFont *obj) {
  PyGdkFont_Object *self;

  self = (PyGdkFont_Object *)PyObject_NEW(PyGdkFont_Object, &PyGdkFont_Type);
  /*gdk_font_ref(obj);*/
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static PyObject *
PyGdkColor_New(GdkColor *obj) {
  PyGdkColor_Object *self;

  self = (PyGdkColor_Object *)PyObject_NEW(PyGdkColor_Object,&PyGdkColor_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static void
PyGtkAccelerator_Dealloc(PyGtkAccelerator_Object *self) {
  gtk_accelerator_table_unref(self->obj); 
  PyMem_DEL(self);
}

static int
PyGtkAccelerator_Compare(PyGtkAccelerator_Object *self,
                            PyGtkAccelerator_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGtkAccelerator_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkAccelerator",
  sizeof(PyGtkAccelerator_Object),
  0,
  (destructor)PyGtkAccelerator_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGtkAccelerator_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGtkStyle_Dealloc(PyGtkStyle_Object *self) {
  gtk_style_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtkStyle_Compare(PyGtkStyle_Object *self, PyGtkStyle_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *PyGtkStyle_GetAttr(PyGtkStyle_Object *self, char *attr) {
  GtkStyle *style = self->obj;
  PyObject *ret;
  int i;

  if (!strcmp(attr, "fg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->fg[i]));
    return ret;
  }
  if (!strcmp(attr, "bg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->bg[i]));
    return ret;
  }
  if (!strcmp(attr, "light")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->light[i]));
    return ret;
  }
  if (!strcmp(attr, "dark")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->dark[i]));
    return ret;
  }
  if (!strcmp(attr, "mid")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->mid[i]));
    return ret;
  }
  if (!strcmp(attr, "text")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->text[i]));
    return ret;
  }
  if (!strcmp(attr, "base")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->base[i]));
    return ret;
  }
  if (!strcmp(attr, "black"))
    return PyGdkColor_New(&style->black);
  if (!strcmp(attr, "white"))
    return PyGdkColor_New(&style->white);
  if (!strcmp(attr, "font")) {
    gdk_font_ref(style->font);
    return PyGdkFont_New(style->font);
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static PyTypeObject PyGtkStyle_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkStyle",
  sizeof(PyGtkStyle_Object),
  0,
  (destructor)PyGtkStyle_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGtkStyle_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGtkStyle_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkFont_Dealloc(PyGdkFont_Object *self) {
  gdk_font_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkFont_Compare(PyGdkFont_Object *self, PyGdkFont_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkFont_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkFont",
  sizeof(PyGdkFont_Object),
  0,
  (destructor)PyGdkFont_Dealloc,
  (printfunc)0,
  (getattrfunc)0,                  
  (setattrfunc)0,
  (cmpfunc)PyGdkFont_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColor_Dealloc(PyGdkColor_Object *self) {
  PyMem_DEL(self);
}

static int
PyGdkColor_Compare(PyGdkColor_Object *self, PyGdkColor_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkColor_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColor",
  sizeof(PyGdkColor_Object),
  0,
  (destructor)PyGdkColor_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkColor_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static PyObject *
PyGdkEvent_New(GdkEvent *obj) {
  PyGdkEvent_Object *self;

  self = (PyGdkEvent_Object *)PyObject_NEW(PyGdkEvent_Object,&PyGdkEvent_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  self->attrs = PyDict_New();
  PyDict_SetItemString(self->attrs, "type", PyInt_FromLong(obj->type));
  /* XXX Does anyone need the window attribute?? */
  switch(obj->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
      PyDict_SetItemString(self->attrs, "area", Py_BuildValue("(iiii)",
        obj->expose.area.x, obj->expose.area.y, obj->expose.area.width,
        obj->expose.area.height));
      PyDict_SetItemString(self->attrs, "count", PyInt_FromLong(
        obj->expose.count));
      break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->motion.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->motion.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->motion.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->motion.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->motion.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->motion.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->motion.state));
      PyDict_SetItemString(self->attrs, "is_hint", PyInt_FromLong(
        obj->motion.is_hint));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->motion.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->motion.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->motion.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->motion.y_root));
      break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->button.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->button.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->button.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->button.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->button.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->button.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->button.state));
      PyDict_SetItemString(self->attrs, "button", PyInt_FromLong(
        obj->button.button));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->button.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->button.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->button.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->button.y_root));
      break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(obj->key.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->key.state));
      PyDict_SetItemString(self->attrs, "keyval", PyInt_FromLong(
        obj->key.keyval));
      PyDict_SetItemString(self->attrs, "string", PyString_FromStringAndSize(
        obj->key.string, obj->key.length));
      break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
      /*subwindow*/
      PyDict_SetItemString(self->attrs, "detail", PyInt_FromLong(
        obj->crossing.detail));
      break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
      PyDict_SetItemString(self->attrs, "_in", PyInt_FromLong(
        obj->focus_change.in));
      break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
      PyDict_SetItemString(self->attrs, "x", PyInt_FromLong(obj->configure.x));
      PyDict_SetItemString(self->attrs, "y", PyInt_FromLong(obj->configure.y));
      PyDict_SetItemString(self->attrs, "width", PyInt_FromLong(
        obj->configure.width));
      PyDict_SetItemString(self->attrs, "height", PyInt_FromLong(
        obj->configure.height));
      break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
      PyDict_SetItemString(self->attrs, "atom", PyInt_FromLong(
        obj->property.atom));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->property.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->property.state));
      break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
      PyDict_SetItemString(self->attrs, "selection", PyInt_FromLong(
        obj->selection.selection));
      PyDict_SetItemString(self->attrs, "target", PyInt_FromLong(
        obj->selection.target));
      PyDict_SetItemString(self->attrs, "property", PyInt_FromLong(
        obj->selection.property));
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->selection.requestor));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->selection.time));
      break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->proximity.time));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->proximity.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->proximity.deviceid));
    case GDK_DRAG_BEGIN:        /*GdkEventDragBegin         dragbegin*/
    case GDK_DRAG_REQUEST:      /*GdkEventDragRequest       dragrequest*/
    case GDK_DROP_ENTER:        /*GdkEventDropEnter         dropenter*/
    case GDK_DROP_LEAVE:        /*GdkEventDropLeave         dropleave*/
    case GDK_DROP_DATA_AVAIL:   /*GdkEventDropDataAvailable dropdataavailable*/
      break; /* XXXX I will do drag and drop later */
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->visibility.state));
      break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
      break;
    case GDK_OTHER_EVENT:
    default:
  }
  return (PyObject *)self;
}

static void
PyGdkEvent_Dealloc(PyGdkEvent_Object *self) {
  Py_XDECREF(self->attrs);
  PyMem_DEL(self);
}

static PyObject *
PyGdkEvent_GetAttr(PyGdkEvent_Object *self, char *attr) {
  PyObject *ret;
  ret = PyDict_GetItemString(self->attrs, attr);
  if (ret != NULL) {
    Py_INCREF(ret);
    return ret;
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static int
PyGdkEvent_Compare(PyGdkEvent_Object *self, PyGdkEvent_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkEvent_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkEvent",
  sizeof(PyGdkEvent_Object),
  0,
  (destructor)PyGdkEvent_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkEvent_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkEvent_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

%}

