#include <stdlib.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSUtilities.h>
#include <GToolKit/GToolKit.h>

@interface StyleTest : NSObject
{
    GTKStyle *style;
    GdkColor *color;
}
- (void) setStyle:(GTKStyle *) initial_style;
- (void) clicked:(GTKWidget *) sender;
@end

@implementation StyleTest

- (void) setStyle:(GTKStyle *) initial_style
{
    /* create copy of the initial button style */
    style = [initial_style copy];
    color = &((GtkStyle *) [style gtk])->bg[GTK_STATE_NORMAL];
}

- (void) clicked:(GTKWidget *) sender
{
    /* temporarily reset to rc-style */
    [sender setRcStyle];

    /* rc-file only sets fg-color, this sets a random bg-color */
    color->red   = 65536.0 * rand() / (RAND_MAX + 1.0);
    color->green = 65536.0 * rand() / (RAND_MAX + 1.0);
    color->blue  = 65536.0 * rand() / (RAND_MAX + 1.0);

    /* tell widget to use the modified style */
    [sender setStyle:style];
}

- (void) dealloc
{
    [style release];
    [super dealloc];
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKButton *button;
    StyleTest *tester;

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [GTKApp rcParse:@"style.rc"];

    NSLog(@"rcGetDefaultFiles returns:\n%@", [GTKApp rcGetDefaultFiles]);

    button = [GTKButton buttonWithLabel:@"Style Test Program"];
    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    tester = [[StyleTest new] autorelease];

    [window setBorderWidth:6];
    [window add:button];
    [window show];

    [tester setStyle:[button getStyle]];
    [button connectSignal:@"clicked" withTarget:tester sel:@selector(clicked:)];

    [GTKApp run];
    [pool release];
    return 0;
}
