#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>
#include "Calc.h"

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Calc *calc = [[Calc new] autorelease];
    GTKTable *table;
    GTKWindow *window;
    GTKAccelGroup *accel;
    GTKEntry *entry;
    GTKButton *button;
    GTKTooltips *tips;
    GTKAction *action;
    NSString *str[][4] = { { @"1", @"2", @"3", @"+" },
			   { @"4", @"5", @"6", @"-" },
			   { @"7", @"8", @"9", @"*" },
			   { @"C", @"0", @"=", @"/" } };
    int i, j;

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];

    tips = [GTKTooltips tooltips];
    accel = [GTKAccelGroup accelGroup];
    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    [window setBorderWidth:5];

    entry = [GTKEntry entry];
    [entry setEditable:NO];

    table = [GTKTable tableWithRows:5 columns:4 homogeneous:NO];
    [table attachDefaults:entry leftAttach:0 rightAttach:4
	   topAttach:0 bottomAttach:1];

    [calc setTarget:entry];

    action = [GTKAction actionWithTarget:calc selector:@selector(gate:)];

    for (i = 0; i < 4; ++i)
	for (j = 0; j < 4; ++j)
	{
	    int tag = [str[i][j] characterAtIndex:0];

	    button = [GTKButton buttonWithLabel:str[i][j]];
	    [button setTag:tag];
	    [button connectSignal:@"clicked" withAction:action];
	    [button addAccelerator:@"clicked" accelGroup:accel
		    accelKey:tag accelMods:0 accelFlags:0];
	    [table attachDefaults:button leftAttach:j rightAttach:j+1
		   topAttach:i+1 bottomAttach:i+2];
	    [tips setTip:button tipText:str[i][j] tipPrivate:nil];
	}

    [window add:table];
    [window addAccelGroup:accel];
    [table setColSpacings:5];
    [table setRowSpacings:5];
    [window setUsize:200 height:200];
    [window show];

    [GTKApp run];
    [pool release];
    return 0;
}
