#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    GTKWindow *window;
    GTKButton *button;
    GTKStyle *style;
    GtkStyle *gtk_style;
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [GTKApp rcParse:@"style.rc"];

    button = [GTKButton buttonWithLabel:@"Style Test Program"];
    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];

    /* create copy of current button style */
    style = [[button getStyle] copy];
    gtk_style = [style gtk];

    /* rc-file only sets fg-color, this sets the bg-color */
    gdk_color_parse("yellow", &gtk_style->bg[GTK_STATE_NORMAL]);
    gdk_color_alloc([window getColormap], &gtk_style->bg[GTK_STATE_NORMAL]);

    /* tell button to use the new style */
    [button setStyle:style];
    [style release];

    [window borderWidth:8];
    [window add:button];
    [window show];

    [window connectSignal:@"destroy" withAction:
	    [GTKAction actionWithTarget:GTKApp selector:@selector(terminate:)]];

    [GTKApp run];
    [pool release];
    return 0;
}
